<?php
// controllers/usuario.php — 0=OK, 1=Error, 2=IP no coincide
declare(strict_types=1);

/* ==== Salida texto plano y logging ==== */
header('Content-Type: text/plain; charset=utf-8');
ini_set('display_errors', '0');                // no muestres errores al cliente
error_reporting(E_ALL);
$logDir = realpath(__DIR__ . '/../storage/logs') ?: (__DIR__ . '/../storage/logs');
if (!is_dir($logDir)) { @mkdir($logDir, 0777, true); }
ini_set('log_errors', '1');
ini_set('error_log', $logDir . '/auth.log');

function elog(string $m): void { error_log('[AUTH] ' . $m); }
function out(string $s): void { echo $s; exit; }
function client_ip(): string {
  $ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
  if (strpos($ip, ',') !== false) $ip = trim(explode(',', $ip)[0]);
  return trim($ip);
}

/* ==== Cargar modelo y conexión ==== */
$pathModel = realpath(__DIR__ . '/../models/usuario.php');
if (!$pathModel) { elog('No se encontró models/usuario.php'); out('1'); }
require_once $pathModel;

/* Busca conex.php en dos rutas posibles */
$pathConex = realpath(__DIR__ . '/../views/pages/conex.php') ?: realpath(__DIR__ . '/../conex.php');
if (!$pathConex) { elog('No se encontró conex.php'); out('1'); }
require_once $pathConex;

/* Normaliza conexión */
$db = null;
if (isset($conn) && $conn instanceof mysqli) { $db = $conn; }
elseif (isset($conex) && $conex instanceof mysqli) { $db = $conex; }
if (!$db instanceof mysqli) { elog('Sin conexión mysqli en $conn/$conex'); out('1'); }
mysqli_set_charset($db, 'utf8mb4');

/* ==== Entradas ==== */
$boton   = $_POST['boton']   ?? '';
$usuario = isset($_POST['usuario']) ? trim((string)$_POST['usuario']) : '';
$pass    = (string)($_POST['pass'] ?? '');

/* ==== Cerrar sesión ==== */
if ($boton === 'cerrar') {
  session_start();
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
  out('0');
}

/* ==== Login ==== */
if ($boton === 'ingresar') {
  if ($usuario === '' || $pass === '') { out('1'); }

  // Autenticar
  try {
    $ins = new insertar();
    $arr = $ins->identificar($usuario, $pass); // [0]=id, [1]=usuario, [4]=sucursal, [15]=rol
  } catch (Throwable $e) {
    elog('Excepción identificar(): ' . $e->getMessage());
    out('1');
  }
  if (!is_array($arr) || (int)($arr[0] ?? 0) === 0) { out('1'); }

  $idusuario = (int)$arr[0];
  $ipActual  = client_ip();

  // Validación/registro de IP (si tienes la columna ip_permitida)
  $ipCampoExiste = false;
  $rs = $db->query("SHOW COLUMNS FROM tbr_usuario LIKE 'ip_permitida'");
  if ($rs) { $ipCampoExiste = (bool)$rs->num_rows; $rs->free(); }

  if ($ipCampoExiste) {
    $ipDB = null;
    $sqlSel = "SELECT ip_permitida FROM tbr_usuario WHERE idusuario = ? LIMIT 1";
    if ($stmt = $db->prepare($sqlSel)) {
      $stmt->bind_param('i', $idusuario);
      $stmt->execute();
      $stmt->bind_result($ipDB);
      $stmt->fetch();
      $stmt->close();
    } else {
      elog('Prepare sel ip_permitida falló: ' . $db->error);
      out('1');
    }

    if ($ipDB === null || $ipDB === '') {
      $sqlUpd = "UPDATE tbr_usuario SET ip_permitida = ? WHERE idusuario = ?";
      if ($stmt = $db->prepare($sqlUpd)) {
        $stmt->bind_param('si', $ipActual, $idusuario);
        if (!$stmt->execute()) { elog('Upd ip_permitida falló: ' . $db->error); out('1'); }
        $stmt->close();
      } else {
        elog('Prepare upd ip_permitida falló: ' . $db->error);
        out('1');
      }
    } else {
      if (trim((string)$ipDB) !== $ipActual) {
        // IP no coincide
        out('2');
      }
    }
  }

  // Sesión
  $secure = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
  session_set_cookie_params([
    'lifetime'=>0,'path'=>'/','domain'=>'','secure'=>$secure,'httponly'=>true,'samesite'=>'Lax'
  ]);
  session_start();
  session_regenerate_id(true);

  $_SESSION['ingreso']   = 'YES';
  $_SESSION['idusuario'] = (int)$arr[0];
  $_SESSION['usuario']   = (string)$arr[1];
  $_SESSION['sucursal']  = $arr[4]  ?? null;
  $_SESSION['rol']       = $arr[15] ?? null;
  $_SESSION['last_activity'] = time();
  $_SESSION['ip'] = $ipActual;
  $_SESSION['ua'] = $_SERVER['HTTP_USER_AGENT'] ?? '';

  // Salida OK
  out('0');
}

/* ==== Acción desconocida ==== */
out('1');
