$(document).ready(function() {
    var table = $("#ticket_hoy").DataTable({
        "bDeferRender": true,
        "paging": false,
        "bLengthChange": false,
        "bFilter": true,
        "order": [[1, "asc"]],		
        "ajax": {
            "url": "funcion_r_hoy.php",
            "type": "POST",
            "cache": false,
            "data": function(d) {
                d.fecha_s = $("#fecha_s").val();
                d.sucursal = $("#sucursal").val(); 
                d.usuario_s = $("#usuario_s").val(); 
                d.timestamp = new Date().getTime();
            }
        },
        "columns": [
            {"data": "cifras", className: "text-center"},
            {"data": "codigo", className: "text-center"},
            {"data": "loteria", className: "text-center"},
            {"data": "numero", className: "text-end"},
            {"data": "fechar", className: "text-end"},
            {"data": "fechaj", className: "text-end"},
            {"data": "valor", className: "text-end"},
            {"data": "negocio", className: "text-center"},
            {"data": "usuario", className: "text-center"},
            {"data": "tope1", className: "text-end"},
            {"data": "tope2", className: "text-end"}
        ],
        "language": {
            "processing": "Procesando...",
            "zeroRecords": "No se encontraron resultados",
            "emptyTable": "Ningún dato disponible en esta tabla",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "infoEmpty": "Mostrando 0 de 0 registros",
            "infoFiltered": "(filtrado de _MAX_ registros)",
            "loadingRecords": "Cargando...",
            "search": "Buscar:",  
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        },
        "dom": '<"d-flex justify-content-between" <"btn-container"B> <"search-container"f>>rtip',
        "buttons": [
    {
        extend: "excelHtml5",
        text: '<i class="fa-solid fa-file-excel"></i>',
        className: "btn btn-success",  // Verde para Excel
        titleAttr: "Exportar a Excel",
        exportOptions: { columns: ":visible" }
    },
    {
        extend: "pdfHtml5",
        text: '<i class="fa-solid fa-file-pdf"></i>',
        className: "btn btn-danger",  // Rojo para PDF
        titleAttr: "Exportar a PDF",
        orientation: "landscape",
        pageSize: "A4",
        exportOptions: { columns: ":visible" }
    }
],

        "drawCallback": function(settings) {
            var api = this.api();
            var intVal = i => typeof i === "string" ? parseFloat(i.replace(/[\$,]/g, "")) || 0 : i || 0;

            var totals = [6, 9, 10].map(col => 
                api.column(col).data().reduce((a, b) => intVal(a) + intVal(b), 0)
            );

            [6, 9, 10].forEach((col, i) => $(api.column(col).footer()).html(totals[i].toFixed(2)));
            $("#total_sum").html("Total Combinado: $" + (totals.reduce((a, b) => a + b, 0)).toFixed(2));
        }
    });

    // Recargar tabla cuando cambie la fecha, usuario o sucursal
    $("#fecha_s, #usuario_s, #sucursal").change(function() {
        table.ajax.reload(null, false);
    });
});
