$(document).ready(function() {
    var table = $("#usuar").DataTable({
        "bDeferRender": true,  // Mejorar rendimiento con grandes tablas
        "paging": true,        // Habilita la paginación
        "bLengthChange": false, // Oculta el selector de cantidad de registros
        "bFilter": true,       // Habilita el filtro de búsqueda
        "bAutoWidth": true,    
        "sPaginationType": "full_numbers",
        "order": [[0, "asc"]], // Ordenar por la columna oculta 'idsuerte'
        "ajax": {
            "url": "funcion_rifa.php",
            "type": "POST"
        },
        "columns": [
            
            {"data": "loteria"},
            {"data": "fecha"},
            {"data": "dia"},           
            {"data": "hora_i"},
            {"data": "hora_f"},
            {"data": "activo"},            
            {"data": "accion"}
        ],
        "oLanguage": {
            "sProcessing": "Procesando...",
            "sLengthMenu": 'Mostrar <select>' +
                '<option value="5">5</option>' +
                '<option value="10">10</option>' +
                '<option value="20">20</option>' +
                '<option value="30">30</option>' +
                '<option value="40">40</option>' +
                '<option value="50">50</option>' +
                '<option value="-1">Todas</option>' +
                '</select> registros',   
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando del (_START_ al _END_) de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "sLoadingRecords": "Por favor espere - cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });

    $(".dataTables_filter").css({
        "float": "right", // Mueve todo el contenedor a la derecha
        "padding-right": "10px" // Espacio adicional si lo deseas
    });

    // Ajustar tamaño de la caja de búsqueda
    $(".dataTables_filter input").css({
        "width": "250px",
        "display": "inline-block",
        "padding": "5px",
        "font-size": "14px",
        "text-align": "right"
    });

    // Redibujar la tabla cada 30 segundos
    /*setInterval(function() {
        table.ajax.reload(null, false); // Recargar los datos sin resetear la paginación
    }, 30000);*/
});
