$(document).ready(function() {
    var table = $("#usuar").DataTable({
        deferRender: true,
        paging: true,
        lengthChange: false,
        searching: true,
        autoWidth: true,
        order: [[0, "asc"]],
        ajax: {
            url: "funcion_suerte.php",
            type: "POST"
        },
        columns: [
            {data: "loteria"},
            {data: "cifras"},
            {data: "suerte"},
            {data: "valor"},
            {data: "detalle"},
            {data: "sucursal"},
            {data: "activo"},
            {data: "accion"}
        ],
        initComplete: function() {
            var api = this.api();
            var filters = {}; // Objeto para almacenar los filtros activos

            // Agregar una fila de filtros en el thead
            $('#usuar thead').append('<tr class="filters"></tr>');

            $('#usuar thead tr:eq(1) th').each(function(i) {
                if (i === 0 || i === 3) { // Filtros en "Suerte" (0) y "Sucursal" (3)
                    var column = api.column(i);
                    filters[i] = ""; // Inicializar filtro vacío

                    var select = $('<select class="column-filter"><option value="">Todos</option></select>')
                        .appendTo($('<th>').appendTo('.filters'))
                        .on('change', function() {
                            filters[i] = $(this).val(); // Guardar filtro seleccionado
                            applyFilters(); // Aplicar todos los filtros
                        });

                    // Poblar el select con valores únicos
                    column.data().unique().sort().each(function(d) {
                        select.append('<option value="' + d + '">' + d + '</option>');
                    });
                } else {
                    $('<th>').appendTo('.filters'); // Agrega columnas vacías para mantener alineación
                }
            });

            // Función para aplicar múltiples filtros
            function applyFilters() {
                api.columns().every(function(index) {
                    if (filters[index]) {
                        this.search('^' + filters[index] + '$', true, false);
                    } else {
                        this.search('');
                    }
                });
                api.draw();
            }
        },
        language: {
            search: "Buscar:",
            paginate: {
                first: "Primero",
                last: "Último",
                next: "Siguiente",
                previous: "Anterior"
            }
        }
    });
});
