<?php
// actulizar_estado_r.php — Actualiza activar de tbr_loteria
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');
header('Content-Type: application/json; charset=utf-8');

// Opcional CORS si lo necesitas fuera del mismo dominio
// header('Access-Control-Allow-Origin: *');
// header('Access-Control-Allow-Headers: Content-Type, Authorization');
// if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

require_once __DIR__ . '/conex.php';

if (!($conn instanceof mysqli)) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error de conexión a BD']); exit;
}

if (function_exists('mysqli_report')) {
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido']); exit;
}

// (Opcional) exigir sesión
if (empty($_SESSION['idusuario'])) {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'Sesión no iniciada']); exit;
}

// Entradas
$idloteria = isset($_POST['idloteria']) ? (int)$_POST['idloteria'] : 0;
$estado    = isset($_POST['estado'])    ? (int)$_POST['estado']    : -1; // 0 o 1

if ($idloteria <= 0 || ($estado !== 0 && $estado !== 1)) {
  http_response_code(400);
  echo json_encode([
    'success'=>false,
    'message'=>'Parámetros inválidos',
    'debug'=>['idloteria'=>$idloteria, 'estado'=>$estado]
  ]);
  exit;
}

try {
  mysqli_set_charset($conn, 'utf8mb4');

  // Guardamos el estado RECIBIDO (no lo invertimos)
  $sql  = "UPDATE tbr_loteria SET activar = ? WHERE idloteria = ?";
  $stmt = $conn->prepare($sql);
  $stmt->bind_param('ii', $estado, $idloteria);
  $stmt->execute();

  if ($stmt->affected_rows >= 0) {
    echo json_encode(['success'=>true, 'idloteria'=>$idloteria, 'estado'=>$estado]);
  } else {
    echo json_encode(['success'=>false, 'message'=>'No se actualizó ningún registro']);
  }
  $stmt->close();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false, 'message'=>'Error al actualizar', 'error'=>$e->getMessage()]);
}
