<?php
include("conex.php");
session_start();

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}
$id_usuario = (int)$_SESSION['idusuario'];

/* ===== INPUT ===== */
$fecha    = mysqli_real_escape_string($conn, $_POST["fecha"] ?? '');
$loterias = mysqli_real_escape_string($conn, $_POST["loterias"] ?? '0'); // opcional
$key      = mysqli_real_escape_string($conn, $_POST["key"] ?? '');

if ($fecha === '' || $key === '') {
    echo json_encode(["error" => "Parámetros inválidos (fecha o key)."]);
    exit();
}

mysqli_set_charset($conn, 'utf8mb4');

$condLoteria = '';
if ($loterias !== '' && $loterias !== '0') {
    $condLoteria = "AND s.id_loteria = '" . $loterias . "'";
}

/*
  Subconsulta bw:
  - Coincidencia exacta por cifras (LPAD vs RIGHT).
  - Mismo día y misma lotería.
  - Filtra por fecha, usuario y key.
  - Incluye: codigo y numero_ticket (LPAD) para luego concatenar por premio.
  Consulta exterior:
  - Agrupa SOLO por premio (sin duplicar).
  - Devuelve: lista de idrifa (ids), codigos y numeros (tickets).
*/
$sql = "
SELECT 
  bw.premio,
  COUNT(DISTINCT bw.idrifa)                                      AS tickets,
  GROUP_CONCAT(DISTINCT bw.suerte_txt ORDER BY bw.suerte_g)      AS suertes,
  GROUP_CONCAT(DISTINCT bw.idrifa)                               AS ids,
  GROUP_CONCAT(DISTINCT bw.codigo ORDER BY bw.codigo)            AS codigos,
  GROUP_CONCAT(DISTINCT bw.numero_ticket ORDER BY bw.numero_ticket) AS numeros
FROM (
  SELECT
      t.idrifa,
      s.suerte_g,
      ts.premio,
      su.suerte AS suerte_txt,
      t.codigo,
      LPAD(t.numero,
           CASE t.id_cifras
             WHEN 1 THEN 2
             WHEN 2 THEN 3
             WHEN 3 THEN 4
           END, '0') AS numero_ticket
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t
    ON  t.fecha = s.fecha_g
    AND s.id_loteria = t.id_loteria
    AND (
          (t.id_cifras = 1 AND LPAD(t.numero,2,'0') = RIGHT(s.numero_g,2))
       OR (t.id_cifras = 2 AND LPAD(t.numero,3,'0') = RIGHT(s.numero_g,3))
       OR (t.id_cifras = 3 AND LPAD(t.numero,4,'0') = RIGHT(s.numero_g,4))
    )
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_suerte        AS su ON su.numero_s  = s.suerte_g
  WHERE t.condicion = 1 
    AND t.estado    = 2
    AND s.activo     = 1
    AND s.condicion  = 1
    AND s.fecha_g    = '$fecha' 
    AND t.id_usuario = '$id_usuario'
    AND ts.id_suerte = s.suerte_g
    AND t.`key`      = '$key'
    $condLoteria
) AS bw
GROUP BY bw.premio
ORDER BY bw.premio DESC;
";

$query = mysqli_query($conn, $sql);

if ($query && mysqli_num_rows($query) > 0) {
    $respuesta = [];
    while ($r = mysqli_fetch_assoc($query)) {
        $respuesta[] = [
            'idrifa'         => null,                           // agrupado
            'codigo'         => (string)($r['codigos'] ?? '-'), // ← CÓDIGOS de tickets ganadores
            'loteria'        => '-',                            // puedes sustituir por texto del select en frontend
            'numero_ganador' => (string)($r['numeros'] ?? ''),  // ← NÚMEROS de ticket ganadores (LPAD)
            'suerte_ga'      => (string)($r['suertes'] ?? ''),
            'premio'         => number_format((float)$r['premio'], 2, '.', ''),
            'estado'         => 'Pendiente',
            'estado_t'       => 2,
            'ids'            => (string)$r['ids']
        ];
    }
} else {
    $respuesta = ['error' => 'Esta vez tu ticket no tiene premio.'];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);
