<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Guayaquil');

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["data"=>[], "error"=>"Error: Sesión no iniciada."]);
    exit();
}

$idusuario = (int)$_SESSION['idusuario'];
include("conex.php");

if (!$conn || !($conn instanceof mysqli)) {
    echo json_encode(["data"=>[], "error"=>"Error de conexión a la base de datos."]);
    exit();
}

// Asegurar charset correcto para evitar usar utf8_encode()
mysqli_set_charset($conn, 'utf8mb4');

// Consulta (últimos 15 días, estado = 2, condicion = 1)
$sql = "
SELECT 
    t.idrifa,
    t.id_cifras,
    c.cifras,
    t.codigo,
    l.loteria,
    t.numero,
    t.fecha AS fechar,
    l.fecha AS fechaj,
    t.valor,
    su.sucursal,
    u.usuario,
    t.condicion
FROM tbr_ticket AS t
INNER JOIN tbr_loteria  AS l  ON l.idloteria = t.id_loteria
INNER JOIN tbr_usuario  AS u  ON u.idusuario = t.id_usuario
INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
INNER JOIN tbr_cifras   AS c  ON c.idcifras   = t.id_cifras
WHERE t.id_usuario = ?
  AND t.condicion = 1
  AND t.estado = 2
  AND t.fecha BETWEEN CURDATE() - INTERVAL 15 DAY AND CURDATE()
ORDER BY t.idrifa ASC
";

$data  = [];
$total = 0.0;

if ($stmt = mysqli_prepare($conn, $sql)) {
    mysqli_stmt_bind_param($stmt, "i", $idusuario);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);

    while ($row = mysqli_fetch_assoc($res)) {
        // valor numérico y formateado
        $valor = (float)$row['valor'];
        $valor_fmt = number_format($valor, 2, '.', ',');

        // numero formateado según id_cifras
        $numero_str = preg_replace('/\D+/', '', (string)$row['numero']); // por si viene con algo raro
        $id_cifras  = (int)$row['id_cifras'];
        if ($id_cifras === 1) {
            $numero_fmt = str_pad(substr($numero_str, -2), 2, '0', STR_PAD_LEFT);
        } elseif ($id_cifras === 2) {
            $numero_fmt = str_pad(substr($numero_str, -3), 3, '0', STR_PAD_LEFT);
        } elseif ($id_cifras === 3) {
            $numero_fmt = str_pad(substr($numero_str, -4), 4, '0', STR_PAD_LEFT);
        } else {
            $numero_fmt = $numero_str;
        }

        $total += $valor;

        // Si quieres incluir un botón eliminar, puedes construir el HTML aquí (opcional)
        // $eliminar = '<a href="actionDelete_fila.php?idrifa='.(int)$row['idrifa'].'" data-toggle="tooltip" data-placement="top" title="Eliminar" class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';

        $data[] = [
            "cifras"   => $row['cifras'],
            "codigo"   => $row['codigo'],
            "loteria"  => $row['loteria'],
            "numero"   => $numero_fmt,
            "fechar"   => $row['fechar'],
            "fechaj"   => $row['fechaj'],
            "valor"    => $valor_fmt,
            "negocio"  => $row['sucursal'],
            "usuario"  => $row['usuario'],
            "pagar"    => $valor_fmt
            // ,"acciones" => $eliminar // <- si lo necesitas en tu DataTable
        ];
    }

    mysqli_stmt_close($stmt);
} else {
    echo json_encode(["data"=>[], "error"=>"Error al preparar la consulta."]);
    exit();
}

// Si quieres devolver también el total numérico, descomenta la línea de abajo
// echo json_encode(["data"=>$data, "total"=>number_format($total, 2, '.', ',')], JSON_UNESCAPED_UNICODE);
// Si tu DataTable solo espera "data":
echo json_encode(["data"=>$data], JSON_UNESCAPED_UNICODE);
