<?php
session_start();
include("conex.php");

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["data" => []]);
    exit;
}

$idusuario = (int)$_SESSION['idusuario'];
$usuario   = htmlspecialchars($_SESSION['usuario'] ?? '');
$sucursal  = htmlspecialchars($_SESSION['sucursal'] ?? '');

// Inicializar la variable $total
$total = 0;
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');
$time_actual  = (int) str_replace(":", "", date("H:i"));

$sql = "SELECT 
            t.idrifa, 
            t.codigo, 
            l.loteria,
            l.hora_inicio,
			l.hora_fin, 
            t.numero, 
            t.fecha_impreso AS fechar, 
            t.hora_impreso,
            t.fecha AS fechaj,  
            t.valor, 
            su.sucursal, 
            u.usuario, 
            u.hora_inicio_a,
            u.hora_fin_a,
            t.condicion
        FROM tbr_ticket AS t
        INNER JOIN tbr_loteria  AS l  ON l.idloteria  = t.id_loteria
        INNER JOIN tbr_usuario  AS u  ON u.idusuario  = t.id_usuario
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
        WHERE t.id_usuario = $idusuario
          AND t.condicion = 1
          AND l.id_pais   = 2      
          AND t.estado    = 2
          AND t.id_cifras = 1      
          AND t.fecha_impreso = '$fecha_actual'
        ORDER BY t.idrifa DESC";

$consulta = mysqli_query($conn, $sql);

$tabla = [];
if ($consulta) {
    while ($row = mysqli_fetch_assoc($consulta)) {
        //$horai = (int) str_replace(":", "", $row['hora_inicio_a']);
        //$horai = (int) str_replace(":", "", $row['hora_inicio']);
        $horai = (int) str_replace(":", "", substr($row['hora_inicio'], 0, 5));
        //$horaf = (int) str_replace(":", "", $row['hora_fin_a']);
        $horaf = (int) str_replace(":", "", substr($row['hora_fin'], 0, 5));
        $valor = (float)$row['valor'];

        $valor_formateado  = number_format($valor, 2, '.', ',');
        $numero_formateado = str_pad($row['numero'], 2, '0', STR_PAD_LEFT);

        $total += $valor;

        if ($time_actual >= $horai && $time_actual <= $horaf) {
            $eliminar = '<a href="actionDelete_fila.php?idrifa=' . $row['idrifa'] . '" 
                            data-toggle="tooltip" data-placement="top" title="Eliminar" 
                            class="btn btn-danger">
                            <i class="fa fa-trash" aria-hidden="true"></i>
                         </a>';
        } else {
            $eliminar = "";
        }

        $tabla[] = [
            "codigo"  => $row['codigo'],
            "loteria" => $row['loteria'],
            "numero"  => $numero_formateado,
            "fechar"  => $row['fechar'] . ' ' . $row['hora_impreso'],
            "fechaj"  => $row['fechaj'],
            "valor"   => $valor_formateado,
            "negocio" => $row['sucursal'],
            "usuario" => $row['usuario'],
            "pagar"   => $valor_formateado,
            "accion"  => $eliminar
        ];
    }
}

echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
