<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(['data' => [], 'success' => false, 'message' => 'No autorizado']);
    exit;
}

$id_usuario = (int)$_SESSION['idusuario'];

require_once __DIR__ . '/conex.php';
if (!isset($conn) || !($conn instanceof mysqli)) {
    echo json_encode(['data' => [], 'success' => false, 'message' => 'Sin conexin a la base de datos']);
    exit;
}

// Charset correcto para evitar utf8_encode (deprecado)
mysqli_set_charset($conn, 'utf8mb4');

/*
  Nota: la columna `key` es palabra reservada en MySQL; se usan backticks.
  Filtro: id_cifras = 3, `key` IS NULL, condicion = 1, usuario actual
*/
$sql = "
SELECT
    t.idrifa,
    t.fecha,
    t.numero,
    t.valor,
    t.condicion,
    t.id_loteria,
    l.loteria
FROM tbr_ticket AS t
INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
WHERE t.id_usuario = ?
  AND t.id_cifras = 3
  AND t.`key` IS NULL
  AND t.condicion = 1
ORDER BY t.idrifa ASC
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(['data' => [], 'success' => false, 'message' => 'Error al preparar la consulta']);
    exit;
}

$stmt->bind_param('i', $id_usuario);
$stmt->execute();
$res = $stmt->get_result();

$data  = [];
$total = 0.0;

while ($row = $res->fetch_assoc()) {
    $valor     = (float)$row['valor'];
    $valorFmt  = number_format($valor, 2, '.', ','); // presentacin
    $numeroFmt = str_pad((string)$row['numero'], 3, '0', STR_PAD_LEFT); // 3 cifras

    $total += $valor;

    // Botn eliminar (si tu front lo usa como HTML dentro de DataTables)
    $eliminar = '<a href="actionDelete_fila.php?idrifa=' . (int)$row['idrifa'] . '" '
              . 'data-toggle="tooltip" data-placement="top" title="Eliminar" '
              . 'class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>';

    $data[] = [
        'loteria' => $row['loteria'],
        'fecha'   => $row['fecha'],
        'numero'  => $numeroFmt,
        'valor'   => $valorFmt,
        'accion'  => $eliminar,
    ];
}

$stmt->close();

echo json_encode(
    [
        'data'    => $data,
        'success' => true,
        'total'   => number_format($total, 2, '.', ','),
    ],
    JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES
);
