<?php
session_start();

// Validación mínima de sesión
if (!isset($_SESSION['idusuario'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['data' => [], 'error' => 'Sesión no válida'], JSON_UNESCAPED_UNICODE);
    exit;
}

$idusuario = (int)($_SESSION['idusuario'] ?? 0);
$usuario   = $_SESSION['usuario']   ?? '';
$sucursal  = $_SESSION['sucursal']  ?? '';

require_once 'conex.php';

// Fuerza UTF-8 real desde MySQL (clave para no usar utf8_encode/utf8_decode)
if (isset($conn) && $conn instanceof mysqli) {
    mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET time_zone = '-05:00'"); // Ecuador
}

header('Content-Type: application/json; charset=utf-8');

// Inicializar total numérico
$total = 0.0;

// ===============================
//   CONSULTA CORREGIDA
// ===============================
// Opción general (2, 3 y 4 cifras):
$sql = "
SELECT 
    t.idrifa,
    t.codigo,
    l.loteria,
    t.numero,				
    t.fecha    AS fechar,   -- fecha de venta
    s.fecha_g  AS fechaj,   -- fecha que juega (sorteo)
    t.valor,
    ts.premio,				
    s.suerte_g,
    suc.sucursal,
    u.usuario				
FROM tbr_sorteo AS s
INNER JOIN tbr_ticket AS t 
    ON  t.id_loteria = s.id_loteria       -- misma lotería
    AND t.fecha      = s.fecha_g          -- misma fecha de sorteo
    AND (
        (t.id_cifras = 3 AND t.numero = RIGHT(s.numero_g, 4))  -- 3 cifras
        
    )
INNER JOIN tbr_cifras   AS c   ON c.idcifras    = t.id_cifras
INNER JOIN tbr_loteria  AS l   ON l.idloteria   = t.id_loteria
INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket  = t.idrifa    
INNER JOIN tbr_usuario  AS u   ON u.idusuario   = t.id_usuario
INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
WHERE t.condicion   = 1 
  AND t.estado      = 2
  AND s.activo      = 1
  AND s.condicion   = 1
  AND l.id_pais     = 1          -- Ecuador
  AND t.id_usuario  = $idusuario        -- o $idusuario si quieres usar el de sesión
  AND ts.id_suerte  = s.suerte_g
  AND s.fecha_g BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()
";

$consulta = mysqli_query($conn, $sql);

if (!$consulta) {
    echo json_encode([
        'data'  => [],
        'error' => 'Error en la consulta: ' . mysqli_error($conn)
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$data = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    // Valores numéricos puros
    $valor  = (float)$row['valor'];
    $premio = (float)$row['premio'];

    // Formatos solo para la salida (texto)
    $valor_formateado  = number_format($valor, 2, '.', ',');
    $premio_formateado = number_format($premio, 2, '.', ',');

    // Si esta consulta es SOLO para 2 cifras, pad a 2 dígitos:
    // Si quieres manejar 3/4 cifras también, aquí ya no harías el str_pad fijo
    $numero_formateado = str_pad((string)$row['numero'], 2, '0', STR_PAD_LEFT);

    // Acumular total como número real (aquí estás sumando el VALOR vendido)
    $total += $valor;

    $data[] = [
        'codigo'  => $row['codigo'],
        'loteria' => $row['loteria'],
        'numero'  => $numero_formateado,
        'fechar'  => $row['fechar'],
        'fechaj'  => $row['fechaj'],
        'valor'   => $valor_formateado,
        'negocio' => $row['sucursal'],
        'usuario' => $row['usuario'],
        'pagar'   => $premio_formateado
    ];
}

// Respuesta JSON
echo json_encode([
    'data'  => $data,
    // Si tu DataTable no espera estas claves extra, puedes quitarlas:
    'total' => number_format($total, 2, '.', ','),
], JSON_UNESCAPED_UNICODE);
