<?php
session_start();
include("conex.php");

// Evitar advertencias: usar valores por defecto si las variables de sesión son nulas
$idusuario  = mysqli_real_escape_string($conn, $_SESSION['idusuario'] ?? '');
$usuario    = htmlspecialchars($_SESSION['usuario'] ?? '');
$sucursal_s = htmlspecialchars($_SESSION['sucursal'] ?? '');
$rol        = (int)($_SESSION['rol'] ?? 0);

// Obtener parámetros enviados por AJAX
$fecha_seleccionada    = isset($_POST['fecha_s']) ? mysqli_real_escape_string($conn, $_POST['fecha_s']) : '';
$sucursal_seleccionado = isset($_POST['sucursal']) ? mysqli_real_escape_string($conn, $_POST['sucursal']) : '';
$usuario_seleccionado  = isset($_POST['usuario_s']) ? mysqli_real_escape_string($conn, $_POST['usuario_s']) : '';

// Verificar y formatear la fecha correctamente
if (!empty($fecha_seleccionada)) {
    $fecha_seleccionada = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_seleccionada)));
} else {
    $fecha_seleccionada = date('Y-m-d'); // Usar la fecha actual si no se recibe una
}

error_log("Fecha seleccionada después de procesar: " . $fecha_seleccionada);

// Inicializar variables para totales
$total       = 0;
$totalp      = 0;
$totalTope1  = 0;
$totalTope2  = 0;

// Establecer la zona horaria de Guayaquil
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');

// ================================================
//  CONSULTA SQL SEGÚN ROL
// ================================================
$sql = '';

if ($rol == 1) {
    // Rol 1: Admin general (ve Ecuador + Argentina)
    $sql = "
        SELECT 
            t.idrifa,
            t.id_cifras,
            c.cifras,
            t.codigo,
            t.`key`,
            l.loteria,
            l.id_pais,
            s.suerte_g,
            t.numero AS numero_ganador, 
            t.valor,
            ts.premio, 
            u.usuario,
            t.tope1,
            t.tope2, 
            u.idusuario,
            suc.idsucursal,
            suc.sucursal,
            t.estado,
            t.fecha
        FROM tbr_sorteo AS s
        INNER JOIN tbr_loteria AS l 
                ON l.idloteria = s.id_loteria
        INNER JOIN tbr_ticket AS t 
                ON t.id_loteria = s.id_loteria   -- misma lotería
               AND t.fecha      = s.fecha_g      -- misma fecha
               AND (
                    (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR  -- 2 cifras
                    (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR  -- 3 cifras
                    (t.id_cifras = 3 AND t.numero = s.numero_g)               -- 4 cifras
               )
        INNER JOIN tbr_cifras        AS c   ON c.idcifras   = t.id_cifras
        INNER JOIN tbr_ticket_suerte AS ts  ON ts.id_ticket = t.idrifa    
        INNER JOIN tbr_usuario       AS u   ON u.idusuario  = t.id_usuario
        INNER JOIN tbr_sucursal      AS suc ON suc.idsucursal = u.id_sucursal
        WHERE t.condicion = 1 
          AND t.estado >= 2
          AND s.activo = 1
          AND s.condicion = 1
          AND l.id_pais IN (1, 2)           -- 1 = Ecuador, 2 = Argentina
          AND ts.id_suerte = s.suerte_g
          AND s.fecha_g = '$fecha_seleccionada'
    ";
}

if ($rol == 3) {
    // Rol 3: Administrador por sucursal/usuario
    // Aquí también dejamos Ecuador + Argentina. 
    // Si quisieras solo Argentina, cambia IN (1,2) por = 2.
    $sql = "
        SELECT 
            t.idrifa,
            t.id_cifras,
            c.cifras,
            t.codigo,
            t.`key`,
            l.loteria,
            l.id_pais,
            s.suerte_g,
            t.numero AS numero_ganador,
            t.valor,
            ts.premio, 
            u.usuario,
            t.tope1,
            t.tope2, 
            u.idusuario,
            suc.idsucursal,
            suc.sucursal,
            t.estado,
            t.fecha
        FROM tbr_sorteo AS s
        INNER JOIN tbr_loteria AS l 
                ON l.idloteria = s.id_loteria
        INNER JOIN tbr_ticket AS t 
                ON t.id_loteria = s.id_loteria     -- misma lotería
               AND t.fecha      = s.fecha_g        -- misma fecha
               AND (
                    (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
                    (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
                    (t.id_cifras = 3 AND t.numero = s.numero_g)
               )
        INNER JOIN tbr_cifras        AS c   ON c.idcifras   = t.id_cifras
        INNER JOIN tbr_ticket_suerte AS ts  ON ts.id_ticket = t.idrifa    
        INNER JOIN tbr_usuario       AS u   ON u.idusuario  = t.id_usuario
        INNER JOIN tbr_sucursal      AS suc ON suc.idsucursal = u.id_sucursal
        WHERE t.condicion = 1 
          AND t.estado >= 2
          AND s.activo = 1
          AND s.condicion = 1
          AND l.id_pais IN (1, 2)            -- Ecuador y Argentina
          AND ts.id_suerte = s.suerte_g
          AND u.id_administrador = '$idusuario'
          AND s.fecha_g = '$fecha_seleccionada'
    ";
}

// Si por algún motivo no hay SQL (rol distinto de 1 o 3)
if ($sql === '') {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        "data"       => [],
        "total"      => "0.00",
        "totalp"     => "0.00",
        "totalTope1" => "0.00",
        "totalTope2" => "0.00"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// ================================================
//  FILTROS EXTRA: SUCURSAL / USUARIO
// ================================================

// Agregar filtro por sucursal si se selecciona
if (!empty($sucursal_seleccionado) && $sucursal_seleccionado !== 'Seleccionar una sucursal') {
    $sql .= " AND suc.idsucursal = '$sucursal_seleccionado'";
}

// Agregar filtro por usuario si se selecciona
if (!empty($usuario_seleccionado) && $usuario_seleccionado !== 'Seleccione un usuario') {
    $sql .= " AND u.idusuario = '$usuario_seleccionado'";
}

$sql .= " ORDER BY t.idrifa DESC";

error_log("Consulta SQL: " . $sql);

// Ejecutar la consulta SQL
$consulta = mysqli_query($conn, $sql);
if (!$consulta) {
    error_log("Error en la consulta: " . mysqli_error($conn));
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        "data"       => [],
        "total"      => "0.00",
        "totalp"     => "0.00",
        "totalTope1" => "0.00",
        "totalTope2" => "0.00"
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Procesar los resultados
$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {

    // Traducir suerte_g a texto
    $suerte_g = (int)$row['suerte_g'];
    switch ($suerte_g) {
        case 1:  $suerteTexto = 'Primera';  break;
        case 2:  $suerteTexto = 'Segunda';  break;
        case 3:  $suerteTexto = 'Tercera';  break;
        case 4:  $suerteTexto = 'Cuarta';   break;
        case 5:  $suerteTexto = 'Quinta';   break;
        case 6:  $suerteTexto = 'Sexta';    break;
        case 7:  $suerteTexto = 'Séptima';  break;
        case 8:  $suerteTexto = 'Octava';   break;
        case 9:  $suerteTexto = 'Novena';   break;
        case 10: $suerteTexto = 'Decima';   break;
        default: $suerteTexto = 'Desconocido';
    }

    $valor   = (float)$row['valor'];
    $premio  = (float)$row['premio'];
    $total  += $valor;
    $totalp += $premio;

    $tope1 = (float)$row['tope1'];
    $tope2 = (float)$row['tope2'];

    // Cálculo de pago por tope con protección si $valor = 0
    $pago_tope1 = 0;
    $pago_tope2 = 0;

    if ($valor > 0) {
        // Tu fórmula original simplificada: premio * (tope / valor)
        $pago_tope1 = $premio * ($tope1 / $valor);
        $pago_tope2 = $premio * ($tope2 / $valor);
    }

    // Sumar los valores de tope1 y tope2
    $totalTope1 += (float)$pago_tope1;
    $totalTope2 += (float)$pago_tope2;

    // Calcular la diferencia de días entre la fecha del sorteo y la actual
    $fecha_ganador  = new DateTime($row['fecha']);
    $fecha_actual_d = new DateTime();
    $diferencia_dias = $fecha_ganador->diff($fecha_actual_d)->days;

    // Determinar el estado (Caducado, Pendiente, Pagado)
    if ($diferencia_dias > 8) {
        $estado = 'Caducado';
    } else {
        if ((int)$row['estado'] == 2) {
            $estado = 'Pendiente';
        } elseif ((int)$row['estado'] == 3) {
            $estado = 'Pagado';
        } else {
            $estado = 'Desconocido';
        }
    }

    // Ajustar longitud del número según id_cifras
    $id_cifras = (int)$row['id_cifras'];
    if ($id_cifras === 1) {
        $lenNumero = 2;  // dos cifras
    } elseif ($id_cifras === 2) {
        $lenNumero = 3;  // tres cifras
    } else {
        $lenNumero = 4;  // cuatro cifras
    }
    $numero_formateado = str_pad($row['numero_ganador'], $lenNumero, '0', STR_PAD_LEFT);

    // Traducir id_pais a texto
    $paisTexto = 'Otro';
    if (isset($row['id_pais'])) {
        $id_pais = (int)$row['id_pais'];
        if ($id_pais === 1) {
            $paisTexto = 'Ecuador';
        } elseif ($id_pais === 2) {
            $paisTexto = 'Argentina';
        } else {
            $paisTexto = (string)$id_pais;
        }
    }

    $tabla[] = [
        "cifras"  => $row['cifras'],
        "codigo"  => $row['codigo'],
        "key"     => $row['key'],
        "loteria" => $row['loteria'],
        "pais"    => $paisTexto, // 👈 para que lo puedas mostrar en la tabla
        "suerte"  => $suerteTexto,
        "numero"  => $numero_formateado,
        "valor"   => number_format($valor, 2, '.', ','),
        "pagar"   => number_format($premio, 2, '.', ','),
        "negocio" => $row['sucursal'],
        "usuario" => $row['usuario'],
        "tope1"   => number_format($pago_tope1, 2, '.', ','),
        "tope2"   => number_format($pago_tope2, 2, '.', ','),
        "estado"  => $estado
    ];
}

// Enviar respuesta JSON con los totales incluidos
header('Content-Type: application/json; charset=utf-8');
echo json_encode([
    "data"       => $tabla,
    "total"      => number_format($total, 2, '.', ','),
    "totalp"     => number_format($totalp, 2, '.', ','),
    "totalTope1" => number_format($totalTope1, 2, '.', ','),
    "totalTope2" => number_format($totalTope2, 2, '.', ',')
], JSON_UNESCAPED_UNICODE);
?>
