<?php
session_start();
include("conex.php");

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal_s = htmlspecialchars($_SESSION['sucursal']);
$rol = mysqli_real_escape_string($conn, $_SESSION['rol']);

// Obtener el usuario y sucursal seleccionados desde la petición AJAX
$fecha_seleccionada    = isset($_POST['fecha_s']) ? mysqli_real_escape_string($conn, $_POST['fecha_s']) : '';
$sucursal_seleccionado = isset($_POST['sucursal']) ? mysqli_real_escape_string($conn, $_POST['sucursal']) : '';
$usuario_seleccionado = isset($_POST['usuario_s']) ? mysqli_real_escape_string($conn, $_POST['usuario_s']) : '';

// Verificar y formatear la fecha correctamente
if (!empty($fecha_seleccionada)) {
    $fecha_seleccionada = date('Y-m-d', strtotime(str_replace('/', '-', $fecha_seleccionada)));
} else {
    $fecha_seleccionada = date('Y-m-d'); // Usar la fecha actual si no se recibe una
}

error_log("Fecha seleccionada después de procesar: " . $fecha_seleccionada);

// Inicializar la variable $total
$total = 0;
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');
//$fecha_actual->modify('-1 day');
//$fecha_actual = $fecha_actual->format('Y-m-d');
// Comenzamos con la consulta básica de todos los registros del día
if( $rol == 1)
{
    $sql = "SELECT 
            t.idrifa,
			t.id_cifras,
			c.cifras,
            t.codigo, 
            l.loteria, 
            t.numero, 
            t.fecha_impreso as fechar,
			t.hora_impreso,
            t.fecha as fechaj,  
            t.valor, 
            su.sucursal, 
            u.usuario, 
            u.hora_inicio_a,
            u.hora_fin_a, 
			t.tope1, 
			t.tope2,
            t.condicion
        FROM tbr_ticket AS t
		INNER JOIN tbr_cifras as c ON c.idcifras = t.id_cifras
        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
        INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
        WHERE t.condicion = 1 
          AND t.estado >= 2
          AND t.fecha_impreso = '$fecha_seleccionada'";
}
if( $rol == 3)
{          
    $sql = "SELECT 
            t.idrifa,
			t.id_cifras,
			c.cifras,
            t.codigo, 
            l.loteria, 
            t.numero, 
            t.fecha_impreso as fechar,
			t.hora_impreso,
            t.fecha as fechaj,  
            t.valor, 
            su.sucursal,
            u.usuario, 
            u.hora_inicio_a,
            u.hora_fin_a, 
			t.tope1, 
			t.tope2,
            t.condicion
        FROM tbr_ticket AS t
		INNER JOIN tbr_cifras as c ON c.idcifras = t.id_cifras
        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
        INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
        WHERE t.condicion = 1 
          AND t.estado >= 2
		  AND u.id_administrador = '$idusuario'
          AND t.fecha_impreso = '$fecha_seleccionada'";
}
// Filtrar por sucursal si se ha seleccionado una
if (!empty($sucursal_seleccionado) && $sucursal_seleccionado !== 'Seleccionar una sucursal') {
    $sql .= " AND su.idsucursal = '$sucursal_seleccionado'";
}

// Filtrar por usuario si se ha seleccionado uno
if (!empty($usuario_seleccionado) && $usuario_seleccionado !== 'Seleccione un usuario') {
    $sql .= " AND t.id_usuario = '$usuario_seleccionado'";
}

$sql .= " ORDER BY t.idrifa DESC";

// Ejecutar consulta
$consulta = mysqli_query($conn, $sql);
if (!$consulta) {
    die("Error en la consulta: " . mysqli_error($conn));
}

$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // No es necesario convertir a enteros, podemos comparar directamente las fechas
    $valor = (float)$row['valor'];  
    $tope1 = (float)$row['tope1'];  
    $tope2 = (float)$row['tope2'];  

    // Formatear el valor y número
    $valor_formateado = number_format($valor, 2, '.', ',');
    $tope1_formateado = number_format($tope1, 2, '.', ',');
    $tope2_formateado = number_format($tope2, 2, '.', ',');
    //$numero_formateado = str_pad($row['numero'], 2, '0', STR_PAD_LEFT);
	$numero = $row['numero']; 
	$id_cifras = $row['id_cifras'];

	if ($id_cifras == 1) {
		$numero_formateado = str_pad($numero, 2, '0', STR_PAD_LEFT);
	} elseif ($id_cifras == 2) {
		$numero_formateado = str_pad($numero, 3, '0', STR_PAD_LEFT);
	} elseif ($id_cifras == 3) {
		$numero_formateado = str_pad($numero, 4, '0', STR_PAD_LEFT);
	} else {
		$numero_formateado = $numero; // Si no coincide con 1, 2 o 3, se deja el número sin cambios
	}
    // Sumar al total
    $total += $valor;
	$valortope1 = ($row['tope1'] == 1) ? $valor : 0;
    $valortope2 = ($row['tope1'] == 1) ? 0 : $valor;
    // Acción eliminar
    $eliminar = '<a href="actionDelete_fila.php?idrifa=' . $row['idrifa'] . '" 
                 data-toggle="tooltip" data-placement="top" title="Eliminar" 
                 class="btn btn-danger">
                 <i class="fa fa-trash" aria-hidden="true"></i>
                 </a>';

    // Construir fila en JSON
    $tabla[] = [
        "cifras"    => $row['cifras'],
        "codigo"    => $row['codigo'],
        "loteria"   => $row['loteria'],
        "numero"    => $numero_formateado,
        "fechar"    => $row['fechar'].' '.$row['hora_impreso'],
        "fechaj"    => $row['fechaj'],
        "valor"     => $valor_formateado,
        "negocio"   => $row['sucursal'],
        "usuario"   => $row['usuario'],
        "tope1"   => $tope1_formateado,
        "tope2"   => $tope2_formateado
    ];
}

// Si no hay datos, devolver array vacío
if (empty($tabla)) {
    echo json_encode(["data" => []]);
} else {
    echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
}
?>
