<?php
    session_start();
    include("conex.php");
    
    // Habilitar reporte de errores
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    
    // Verificar sesión
    $idusuario  = $_SESSION['idusuario'] ?? '';
    $usuario    = htmlspecialchars($_SESSION['usuario'] ?? '');
    $sucursal_s = htmlspecialchars($_SESSION['sucursal'] ?? '');
    $rol = mysqli_real_escape_string($conn, $_SESSION['rol']);
    
    // Establecer zona horaria
    date_default_timezone_set('America/Guayaquil');
    
    // Obtener filtros de la solicitud
    $f_usuario  = $_GET['usuario'] ?? '';
    $f_sucursal = $_GET['sucursal'] ?? '';
    $f_fecha_i  = $_GET['fecha_i'] ?? '';
    $f_fecha_f  = $_GET['fecha_f'] ?? '';
    
    // Registrar en log los datos recibidos
    error_log("Recibido: usuario=$f_usuario, sucursal=$f_sucursal, fecha_i=$f_fecha_i, fecha_f=$f_fecha_f");
    
    // Validación de fechas
    if (!empty($f_fecha_i) && !preg_match('/^\d{4}-\d{2}-\d{2}$/', $f_fecha_i)) 
    {
        echo json_encode(["error" => "La fecha de inicio no es válida"], JSON_UNESCAPED_UNICODE);
        exit;
    }
    if (!empty($f_fecha_f) && !preg_match('/^\d{4}-\d{2}-\d{2}$/', $f_fecha_f)) 
    {
        echo json_encode(["error" => "La fecha de fin no es válida"], JSON_UNESCAPED_UNICODE);
        exit;
    }
    if (!empty($f_fecha_i) && !empty($f_fecha_f) && $f_fecha_f < $f_fecha_i) 
    {
        echo json_encode(["error" => "La fecha de fin no puede ser anterior a la fecha de inicio"], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    // Construcción de la consulta SQL para ventas (corregida)
    if( $rol == 1)
    {
        $sql = "SELECT 
    			t.id_cifras,
    			c.cifras,
                t.fecha, 
                s.sucursal,
                t.id_usuario,
                u.usuario,
                SUM(t.valor) AS suma_valor
            FROM tbr_ticket AS t
    		INNER JOIN tbr_cifras AS c ON c.idcifras = t.id_cifras
            INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
            INNER JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
            WHERE t.condicion = 1 
              AND t.estado >= 2
              AND t.id_cifras = 2";
    }
    if( $rol == 3)
    {
    	$sql = "SELECT 
    			t.id_cifras,
    			c.cifras,
                t.fecha, 
                s.sucursal,
                t.id_usuario,
                u.usuario,
                SUM(t.valor) AS suma_valor
            FROM tbr_ticket AS t
    		INNER JOIN tbr_cifras AS c ON c.idcifras = t.id_cifras
            INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
            INNER JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
            WHERE t.condicion = 1 
              AND t.estado >= 2
              AND t.id_cifras = 2
    		  AND u.id_administrador = '$idusuario'";
    }
    // Agregar filtros dinámicamente
    $params = [];
    $types  = "";
    
    if (!empty($f_usuario)) 
    {
        $sql .= " AND u.idusuario = ?";
        $params[] = $f_usuario;
        $types .= "i";
    }
    
    if (!empty($f_sucursal)) 
    {
        $sql .= " AND s.idsucursal = ?";
        $params[] = $f_sucursal;
        $types .= "i";
    }
    
    if (!empty($f_fecha_i) && !empty($f_fecha_f))
    {
        $sql .= " AND t.fecha BETWEEN ? AND ?";
        $params[] = $f_fecha_i;
        $params[] = $f_fecha_f;
        $types .= "ss";
    }
    
    $sql .= " GROUP BY t.id_cifras, t.fecha, s.sucursal, t.id_usuario, u.usuario";
    
    // Registrar consulta en log
    error_log("Consulta SQL final: " . $sql);
    
    $stmt = mysqli_prepare($conn, $sql);
    if ($stmt) 
    {
        if (!empty($params)) {
            mysqli_stmt_bind_param($stmt, $types, ...$params);
        }
        mysqli_stmt_execute($stmt);
        $consulta = mysqli_stmt_get_result($stmt);
    } 
    else 
    {
        error_log("Error en la preparación de la consulta: " . mysqli_error($conn));
        http_response_code(500);
        echo json_encode(["error" => "Error en la consulta"], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    // Procesar resultados y agregar datos de premios
    $tabla = [];
    while ($row = mysqli_fetch_assoc($consulta)) 
    {
        $usuario_sql = $row['id_usuario'];
    
        // Consulta de premios (asegurando que se agrupe correctamente)
        $sql2 = "SELECT COALESCE(SUM(ts.premio), 0) AS Suma_premio
             FROM tbr_ticket_suerte AS ts
             INNER JOIN tbr_ticket AS t ON t.idrifa = ts.id_ticket 
             INNER JOIN tbr_sorteo AS s ON s.fecha_g = t.fecha
             WHERE ts.condicion = 1 
               AND t.condicion = 1 
               AND t.estado > 1
               AND ts.id_suerte = s.suerte_g 
               AND t.id_usuario = ? 
               AND t.fecha = ?		  
               AND (
                    (t.id_cifras = 2 AND ((t.numero) = RIGHT(s.numero_g, 3)))-- Coincidencia de 3 cifras
               )";
    
    
        $stmt2 = mysqli_prepare($conn, $sql2);
        if ($stmt2) {
            mysqli_stmt_bind_param($stmt2, "is", $usuario_sql, $row['fecha']);
            mysqli_stmt_execute($stmt2);
            $consulta2 = mysqli_stmt_get_result($stmt2);
            $suma_p = 0;
            
            if ($row2 = mysqli_fetch_assoc($consulta2)) {
                $suma_p = $row2['Suma_premio'];
            }
    
            mysqli_stmt_close($stmt2);
        } else {
            error_log("Error en la consulta de premios: " . mysqli_error($conn));
        }
    
        // Agregar fila a la tabla
        $tabla[] = [
            "cifras"    => $row['cifras'],
            "fecha"    => $row['fecha'],
            "sucursal" => $row['sucursal'],
            "usuario"  => $row['usuario'],
            "vendido"  => number_format($row['suma_valor'], 2, '.', ''),
            "premio"   => number_format($suma_p, 2, '.', ''),
            "saldo"    => number_format(($row['suma_valor'] - $suma_p), 2, '.', '')
        ];
    }
    
    // Cerrar conexión
    mysqli_close($conn);
    
    // Enviar respuesta JSON con cabecera correcta
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
?>
