<?php
session_start();
include("conex.php");

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal = htmlspecialchars($_SESSION['sucursal']);

// Inicializar la variable $total
$total = 0;
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d'); // Cambio de formato correcto

// Consulta con mysqli (evitar inyeccin SQL)
$sql = "SELECT t.idrifa, 
           t.codigo, 
           l.loteria, 
           t.numero, 
           t.fecha_impreso as fechar, 
           t.fecha as fechaj, 
           t.valor, 
           su.sucursal, 
           u.usuario, 
           t.condicion
    FROM tbr_ticket AS t
    INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
    INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
    INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
    WHERE t.id_usuario = '$idusuario'
      AND t.condicion = 1 
      AND t.estado = 2
      AND id_cifras = 1
      AND l.id_pais = 1
      AND t.fecha_impreso = '$fecha_actual' 
      AND t.fecha > '$fecha_actual'
    ORDER BY t.idrifa ASC";

$consulta = mysqli_query($conn, $sql);

$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir valores correctamente
    $valor = (float)$row['valor'];  
    $valor_formateado = number_format($valor, 2, '.', ',');
    $numero_formateado = str_pad($row['numero'], 3, '0', STR_PAD_LEFT);

    // Sumar al total
    $total += $valor;

    // Accin eliminar
    

    // Construir fila en JSON
    $tabla[] = [
        "codigo"    => $row['codigo'],
        "loteria"   => $row['loteria'],
        "numero"    => $numero_formateado,
        "fechar"    => $row['fechar'],
        "fechaj"    => $row['fechaj'],
        "valor"     => $valor_formateado,
        "negocio"   => $row['sucursal'],
        "usuario"   => $row['usuario'],        
        "pagar"     => $valor_formateado
       
    ];
}

// Enviar JSON limpio
echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
?>
