<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$rol = mysqli_real_escape_string($conn, $_SESSION['rol']);

// Consulta segura con INNER JOIN
if( $rol == 1)
{
    $sql = "SELECT u.idusuario, u.id_sucursal, u.usuario, s.sucursal, u.extra_cupo, u.cupo_activo, u.extra_cupo3, u.cupo_activo3, u.extra_cupo4, u.cupo_activo4,
               u.hora_inicio_v, u.hora_fin_v, u.hora_inicio_a, u.hora_fin_a, u.activo, u.condicion, u.clave, u.id_rol
        FROM tbr_usuario AS u
        left JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
        WHERE u.condicion = 1 ";
}
if( $rol == 3)
{
	$sql = "SELECT u.idusuario, u.id_sucursal, u.usuario, s.sucursal, u.extra_cupo, u.cupo_activo, u.extra_cupo3, u.cupo_activo3, u.extra_cupo4, u.cupo_activo4,
				   u.hora_inicio_v, u.hora_fin_v, u.hora_inicio_a, u.hora_fin_a, u.activo, u.condicion, u.clave, u.id_rol
			FROM tbr_usuario AS u
			left JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
			WHERE u.condicion = 1 and id_administrador = '$idusuario' ";
}

$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir el campo 'activo' en "SI" o "NO"
    $activo_texto = $row['activo'] == 1 ? "SI" : "NO";
    $activo_cupo = $row['cupo_activo'] == 1 ? "SI" : "NO";
    $activo_cupo3 = $row['cupo_activo3'] == 1 ? "SI" : "NO";
    $activo_cupo4 = $row['cupo_activo4'] == 1 ? "SI" : "NO";
    $admin = $row['id_rol'];

    // Botón de activación/desactivación
    $boton_estado = '<label class="switch">
                        <input type="checkbox" class="toggle-switch" data-id="' . $row['idusuario'] . '" ' . ($row['activo'] ? 'checked' : '') . ' data-estado="' . ($row['activo'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
					
	// Botón de activación/desactivación
    $boton_cupo = '<label class="switch">
                        <input type="checkbox" class="toggle-switch2" data-id="' . $row['idusuario'] . '" ' . ($row['cupo_activo'] ? 'checked' : '') . ' data-estado="' . ($row['cupo_activo'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
					// Botón de activación/desactivación
    $boton_cupo3 = '<label class="switch">
                        <input type="checkbox" class="toggle-switch3" data-id="' . $row['idusuario'] . '" ' . ($row['cupo_activo3'] ? 'checked' : '') . ' data-estado="' . ($row['cupo_activo3'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
    $boton_cupo4 = '<label class="switch">
                        <input type="checkbox" class="toggle-switch4" data-id="' . $row['idusuario'] . '" ' . ($row['cupo_activo4'] ? 'checked' : '') . ' data-estado="' . ($row['cupo_activo4'] ? 1 : 0) . '">
                        <span class="slider round"></span>
                    </label>';
    
    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idusuario'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    // Botón de editar
    $editar = '<button class="btn btn-warning toggle-editar" 
                    data-id="' . $row['idusuario'] . '"
                    data-usuario="' . $row['usuario'] . '"
                    data-clave="' . $row['clave'] . '"
                    data-sucursal="' . $row['id_sucursal'] . '"
                    data-cupo="' . $row['extra_cupo'] . '"
                    data-cupo3="' . $row['extra_cupo3'] . '"
                    data-cupo4="' . $row['extra_cupo4'] . '"
                    data-hora_inicio_a="' . $row['hora_inicio_a'] . '"
                    data-hora_fin_a="' . $row['hora_fin_a'] . '">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
                </button>';
	// Botón de editar administrador
    $editar_admin = '<button class="btn btn-warning toggle-editar_ad" 
                    data-id="' . $row['idusuario'] . '"
                    data-usuario="' . $row['usuario'] . '"
                    data-clave="' . $row['clave'] . '">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
                </button>';
	if($admin == 1 || $admin == 3 )
	{
		// Construir fila en JSON
		$usuarios_data[] = [
			"usuario"           => $row['usuario'],
			"clave"           	=> $row['clave'],
			"sucursal"          => '',
			"cupo"              => '',
			"cupo3"             => '',
			"cupo4"             => '',
			"hora_i_anulacion"  => '',
			"hora_f_anulacion"  => '',
			"activo"            => $boton_estado,            
			"accion"            => $editar_admin.' '.$eliminar
			
		];
	}
    else
	{
		// Construir fila en JSON
		$usuarios_data[] = [
			"usuario"           => $row['usuario'],
			"clave"           	=> $row['clave'],
			"sucursal"          => $row['sucursal'],
			"cupo"              => $row['extra_cupo'].' '.$boton_cupo,
			"cupo3"              => $row['extra_cupo3'].' '.$boton_cupo3,
			"cupo4"              => $row['extra_cupo4'].' '.$boton_cupo4,
			"hora_i_anulacion"  => $row['hora_inicio_a'],
			"hora_f_anulacion"  => $row['hora_fin_a'],
			"activo"            => $boton_estado,            
			"accion"            => $editar.' '.$eliminar
			
		];
	}
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
