<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden; /* Evitar desplazamiento horizontal */
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
            z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
        }

        .modal-backdrop {
            z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
        }

        .modal-dialog {
            z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        /* Ajustar la visibilidad del sidebar al colapsar */
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }
		
		/* Estilos del interruptor */
	.switch {
	  position: relative;
	  display: inline-block;
	  width: 60px;
	  height: 34px;
	}

	.switch input {
	  opacity: 0;
	  width: 0;
	  height: 0;
	}
	.slider {
	  position: absolute;
	  cursor: pointer;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: #ccc;
	  transition: 0.4s;
	  border-radius: 34px;
	}

	.slider:before {
	  position: absolute;
	  content: "";
	  height: 26px;
	  width: 26px;
	  border-radius: 50%;
	  left: 4px;
	  bottom: 4px;
	  background-color: white;
	  transition: 0.4s;
	}

	input:checked + .slider {
	  background-color: #4CAF50;
	}

	input:checked + .slider:before {
	  transform: translateX(26px);
	}
	
	
	
	.dt-buttons .btn {
    padding: 6px 10px;
    font-size: 16px;
    border-radius: 5px;
    color: white !important;  /* Asegurar color del texto */
		}

		.btn-success {
			background-color: #28a745 !important;
			border-color: #28a745 !important;
		}

		.btn-danger {
			background-color: #dc3545 !important;
			border-color: #dc3545 !important;
		}


    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo $usuario; ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
					<div class="col-lg-3 col-md-3">
						<div class="form-group">
							<label for="fecha">Fecha*</label>
							<input id="fecha_s" name="fecha_s" type="date" class="form-control border-left-0" required>
						</div>						
					</div>
					
                    <div class="col-lg-3 col-md-3">
						<div class="form-group">
							<label for="sucursal">Sucursal*</label>
							<select class="form-control" id="sucursal" name="sucursal" required></select>
						</div>
					</div> 
					<div class="col-lg-3 col-md-3">
						<div class="form-group">
							<label for="usuario_s">Usuario*</label>
							<select class="form-control" id="usuario_s" name="usuario_s" required></select>
						</div>
					</div> 
                    <div class="modal-body p-2"> <!-- Quitamos el padding para que la tabla ocupe todo -->
						<div class="table-responsive"> <!-- Contenedor para hacer la tabla adaptable -->
							<table id="ticket_hoy" class="table table-striped w-100 m-0"> <!-- Ancho completo y sin margen -->
								<thead>
									<tr class="text-center">
										<th>Cifras <i class="fas fa-sort-numeric-down"></i></th>
										<th>Codigo <i class="fas fa-sort-numeric-down"></i></th>
										<th>Key <i class="fas fa-comments"></i></th>
										<th>Loteria <i class="fas fa-list-ol"></i></th>
										<th>Suerte <i class="fas fa-calendar"></i></th>
										<th>Numero <i class="fas fa-calendar-check"></i></th>
										<th>Valor <i class="fas fa-dollar-sign"></i></th>
										<th>Premio <i class="fas fa-trophy"></i></th>
										<th>Sucursal <i class="fas fa-television"></i></th>
										<th>Usuario <i class="fas fa-user"></i></th>
										<th>Tope1 <i class="fas fa-dollar-sign"></i></th>																		
										<th>Tope2 <i class="fas fa-dollar-sign"></i></th>																		
										<th>Estado <i class="fas fa-money"></i></th>																		
									</tr>
								</thead>
								<tbody>
									<!-- Aquí puedes cargar más datos dinámicamente -->
								</tbody>
								<tfoot>
									<tr>
										<th></th>
										<th></th>
										<th></th>
										<th colspan="1">Totales</th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>										
									</tr>
								</tfoot>
							</table>
						</div>
					</div>                       
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->

	<!-- Scripts -->

<!-- 1) jQuery SIEMPRE primero -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- 2) Bootstrap (solo una vez) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- 3) DataTables + Bootstrap 5 -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<!-- 4) Botones de DataTables (excel, pdf, print) -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<!-- Si vas a usar PDF, necesitas además pdfmake y vfs_fonts:
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
-->

<!-- 5) SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- 6) Font Awesome JS (opcional, ya tienes el CSS arriba) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>

<!-- 7) Tu JS de la tabla -->
<script src="../../resources/js/menu_r_gana.js"></script>

<script>
    // Función para actualizar la fecha y hora en la barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();
    
    // Función para alternar la visibilidad del sidebar
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.querySelector('.main-content');
        if (!sidebar || !mainContent) return;
        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }

    // función para cerrar sesión
    function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }

    // Cargar sucursales y usuarios
    $(document).ready(function() {
        // Cargar las opciones de sucursal
        $.ajax({
            type: "POST",
            url: "datos.php?Accion=GetSucursal",
            success: function(response) {
                $('#sucursal').html(response).fadeIn();
            }
        });

        // Cargar los usuarios basados en la sucursal seleccionada
        $("#sucursal").change(function() {
            var Sucursal = $(this).val();
            $.ajax({
                type: "POST",
                url: "datos.php?Accion=GetUsuario&Sucursal=" + Sucursal,
                success: function(data) {
                    $('#usuario_s').html(data).fadeIn();
                }
            });
        });
    });

    // Setear fecha actual (zona horaria Guayaquil) en el input fecha_s
    document.addEventListener("DOMContentLoaded", function() {
        let now = new Date();
        let ecuadorTime = new Date(now.toLocaleString("en-US", { timeZone: "America/Guayaquil" }));
        let year = ecuadorTime.getFullYear();
        let month = String(ecuadorTime.getMonth() + 1).padStart(2, "0");
        let day = String(ecuadorTime.getDate()).padStart(2, "0");
        let formattedDate = `${year}-${month}-${day}`;
        let dateInput = document.getElementById("fecha_s");
        if (dateInput) {
            dateInput.value = formattedDate;
        }
    });
</script>

</body>
</html>
