<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$cifra = filter_input(INPUT_POST, 'cifra', FILTER_SANITIZE_STRING);
$cupo = filter_input(INPUT_POST, 'cupo', FILTER_VALIDATE_INT) ?: 0;

$condicion = 1;

if (empty($cifra)) {
    echo json_encode(["error" => "Todos los campos son obligatorios."]);
    exit();
}

// Insertar cifra en la base de datos
$sql_insert = "INSERT INTO tbr_cifras (cifras, cupo_cifras, condicion) 
               VALUES (?, ?, ?)";

$stmt = mysqli_prepare($conn, $sql_insert);
if (!$stmt) {
    echo json_encode(["error" => "Error en la preparación de la consulta: " . mysqli_error($conn)]);
    exit();
}

mysqli_stmt_bind_param($stmt, "sii", $cifra, $cupo, $condicion);
$insert_success = mysqli_stmt_execute($stmt);

if (!$insert_success) {
    echo json_encode(["error" => "Error al insertar cifra: " . mysqli_error($conn)]);
    exit();
}

$idcifras = mysqli_insert_id($conn);
mysqli_stmt_close($stmt);

if ($idcifras === 0) {
    echo json_encode(["error" => "Error: No se pudo obtener el ID de la cifra."]);
    exit();
}

// Enviar respuesta de éxito con la URL de la imagen
echo json_encode(["success" => "Cifra registrada exitosamente.", "idcifras" => $idcifras]);

// Cerrar conexión
mysqli_close($conn);
?>
