<?php
// Iniciar sesión
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$idsuerte_a = filter_input(INPUT_POST, 'idsuerte_a', FILTER_VALIDATE_INT);
//$suerte_a = filter_input(INPUT_POST, 'suerte_a', FILTER_SANITIZE_STRING);
$valor_a = filter_input(INPUT_POST, 'valor_a', FILTER_VALIDATE_INT);
$premio_a = filter_input(INPUT_POST, 'premio_a', FILTER_SANITIZE_STRING);
$sucursal_a = filter_input(INPUT_POST, 'sucursal_a', FILTER_VALIDATE_INT);

$suerte_a = filter_input(INPUT_POST, 'suerte_a', FILTER_SANITIZE_FULL_SPECIAL_CHARS);

// Mapeo de valores
$mapa_suerte = [
    "PRIMERA"  => 1,
    "SEGUNDA"  => 2,
    "TERCERA"  => 3,
    "CUARTA"   => 4,
    "QUINTA"   => 5,
    "SEXTA"    => 6,
    "SEPTIMA"  => 7,
    "OCTAVA"   => 8,
    "NOVENA"   => 9,
    "DECIMA"   => 10
];

// Convertir a mayúsculas para evitar problemas de comparación
$suerte_a = strtoupper(trim($suerte_a));

// Verificar si existe en el array, si no, asignar null
$valor_suerte = $mapa_suerte[$suerte_a] ?? null;

//echo $usuario;

if ($suerte_a === false || $valor_a === false || empty($sucursal_a)) {
    echo json_encode(["error" => "Todos los campos son obligatorios y deben tener un formato válido."]);
    exit();
}

// Consulta para actualizar los datos en la base de datos
$query = "UPDATE tbr_suerte SET numero_s = ?, suerte = ?, valor = ?, detalle = ?, id_sucursal = ? WHERE idsuerte = ?";

// Preparar la sentencia SQL
$stmt = $conn->prepare($query);

if ($stmt === false) {
    echo json_encode(["error" => "Error al preparar la consulta: " . $conn->error]);
    exit();
}

// Bind de los parámetros
$stmt->bind_param("isisii", $valor_suerte, $suerte_a, $valor_a, $premio_a, $sucursal_a, $idsuerte_a);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(["success" => true]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

// Cerrar la conexión
$stmt->close();
$conn->close();
?>
