<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
$loteria = filter_input(INPUT_POST, 'loteria', FILTER_VALIDATE_INT) ?: 0;
$suerte = filter_input(INPUT_POST, 'suerte', FILTER_VALIDATE_INT) ?: 0;
$numero = filter_input(INPUT_POST, 'numero', FILTER_SANITIZE_STRING);

$activo = 0;
$condicion = 1;

if (empty($fecha)) {
    echo json_encode(["error" => "Todos los campos son obligatorios."]);
    exit();
}

// Encriptar la contraseña antes de guardarla
//$hashed_password = password_hash($clave, PASSWORD_DEFAULT);

// Insertar usuario en la base de datos
$sql_insert = "INSERT INTO tbr_sorteo (fecha_g, suerte_g, numero_g, id_loteria, activo, condicion) 
               VALUES (?, ?, ?, ?, ?, ?)";

$stmt = mysqli_prepare($conn, $sql_insert);
if (!$stmt) {
    echo json_encode(["error" => "Error en la preparación de la consulta: " . mysqli_error($conn)]);
    exit();
}

mysqli_stmt_bind_param($stmt, "sisiii", $fecha, $suerte, $numero, $loteria, $activo, $condicion);
$insert_success = mysqli_stmt_execute($stmt);

if (!$insert_success) {
    echo json_encode(["error" => "Error al insertar el suerte: " . mysqli_error($conn)]);
    exit();
}

$idsorteo = mysqli_insert_id($conn);
mysqli_stmt_close($stmt);

if ($idsorteo === 0) {
    echo json_encode(["error" => "Error: No se pudo obtener el ID del suerte."]);
    exit();
}

// Enviar respuesta de éxito
echo json_encode(["success" => "Usuario registrado exitosamente.", "idsuerte" => $idusuario]);

// Cerrar conexión
mysqli_close($conn);
?>
