<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
//$suerte = filter_input(INPUT_POST, 'suerte', FILTER_SANITIZE_STRING);
$loteria = filter_input(INPUT_POST, 'loteria', FILTER_VALIDATE_INT) ?: 0;
$valor = filter_input(INPUT_POST, 'valor', FILTER_VALIDATE_INT) ?: 0;
$premio = filter_input(INPUT_POST, 'premio', FILTER_SANITIZE_STRING);
$sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_VALIDATE_INT) ?: 0;
$cifras = filter_input(INPUT_POST, 'cifras', FILTER_VALIDATE_INT) ?: 0;
$activo = 0;
//$dos_c = 1;
$condicion = 1;


$suerte = filter_input(INPUT_POST, 'suerte', FILTER_SANITIZE_FULL_SPECIAL_CHARS);

// Mapeo de valores
$mapa_suerte = [
    "PRIMERA"  		=> 1,	
    "SEGUNDA"  		=> 2,	
    "TERCERA"  		=> 3,	
    "CUARTA"   		=> 4,	
    "QUINTA"   		=> 5,	
    "SEXTA"    		=> 6,	
    "SEPTIMA"  		=> 7,	
    "OCTAVA"   		=> 8,	
    "NOVENA"   		=> 9,	
    "DECIMA"   		=> 10
];

// Convertir a mayúsculas para evitar problemas de comparación
$suerte = strtoupper(trim($suerte));

// Verificar si existe en el array, si no, asignar null
$valor_suerte = $mapa_suerte[$suerte] ?? null;


if (empty($suerte) || empty($sucursal)) {
    echo json_encode(["error" => "Todos los campos son obligatorios."]);
    exit();
}

// Encriptar la contraseña antes de guardarla
//$hashed_password = password_hash($clave, PASSWORD_DEFAULT);

// Insertar usuario en la base de datos
$sql_insert = "INSERT INTO tbr_suerte (numero_s, suerte, valor, detalle, activar, id_sucursal, id_cifras, condicion, id_premio) 
               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = mysqli_prepare($conn, $sql_insert);
if (!$stmt) {
    echo json_encode(["error" => "Error en la preparación de la consulta: " . mysqli_error($conn)]);
    exit();
}

mysqli_stmt_bind_param($stmt, "isisiiiii", $valor_suerte, $suerte, $valor, $premio, $activo, $sucursal, $cifras, $condicion, $loteria);
$insert_success = mysqli_stmt_execute($stmt);

if (!$insert_success) {
    echo json_encode(["error" => "Error al insertar el suerte: " . mysqli_error($conn)]);
    exit();
}

$idusuario = mysqli_insert_id($conn);
mysqli_stmt_close($stmt);

if ($idusuario === 0) {
    echo json_encode(["error" => "Error: No se pudo obtener el ID del suerte."]);
    exit();
}

// Enviar respuesta de éxito
echo json_encode(["success" => "Usuario registrado exitosamente.", "idsuerte" => $idusuario]);

// Cerrar conexión
mysqli_close($conn);
?>
