<?php
// guardar_ticket4.php — Inserta ticket (4 cifras)
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

try {
  if (!isset($_SESSION['idusuario'], $_SESSION['sucursal'])) { echo json_encode(['success'=>false,'message'=>'Sesión no iniciada']); exit; }
  $id_usuario  = (int)$_SESSION['idusuario'];
  $id_sucursal = (int)$_SESSION['sucursal'];

  require __DIR__ . '/conex.php';
  $cn = $conn ?? ($conex ?? null);
  if (!$cn instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
  if (function_exists('mysqli_report')) mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
  mysqli_set_charset($cn,'utf8mb4');

  $post = fn($k) => isset($_POST[$k]) ? trim((string)$_POST[$k]) : '';
  $date2     = $post('date2');
  $idloteria = (int)($_POST['loterias'] ?? 0);
  $valor     = (float)($_POST['valor'] ?? 0);
  $rawNum    = preg_replace('/\D/','',$post('number'));
  $number    = str_pad(substr($rawNum,-4),4,'0',STR_PAD_LEFT);
  $id_cifras = 3; // 4 cifras

  $hoy = date('Y-m-d');
  if (!preg_match('/^\d{4}-\d{2}-\d{2}$/',$date2)) throw new Exception('Fecha inválida (YYYY-MM-DD).');
  if ($date2 < $hoy) throw new Exception('La fecha no puede ser menor a hoy.');
  if ($idloteria<=0) throw new Exception('Seleccione una lotería.');
  if (!preg_match('/^\d{4}$/',$number)) throw new Exception('Número inválido (0000-9999).');
  if ($valor < 0.50) throw new Exception('El valor debe ser ≥ 0.50.');

  $horaHi = (int)date('Hi');
  $HCAST  = "CAST(LPAD(LEFT(REPLACE(hora_fin, ':',''), 4), 4, '0') AS UNSIGNED)";
  $st = $cn->prepare("SELECT $HCAST AS finHHMM, activar, condicion FROM tbr_loteria WHERE idloteria=?");
  $st->bind_param('i',$idloteria); $st->execute();
  $lot = $st->get_result()->fetch_assoc(); $st->close();
  if (!$lot || (int)$lot['activar']!==1 || (int)$lot['condicion']!==1) throw new Exception('Lotería inactiva o inexistente.');
  if ($date2===$hoy && (int)$lot['finHHMM'] < $horaHi) throw new Exception('Fuera de la hora de juego permitida.');

  $st = $cn->prepare("SELECT COALESCE(cupo,0) cupo FROM tbr_sucursal WHERE idsucursal=?");
  $st->bind_param('i',$id_sucursal); $st->execute();
  $cupo_suc = (float)($st->get_result()->fetch_assoc()['cupo'] ?? 0); $st->close();

  $st = $cn->prepare("SELECT CASE WHEN cupo_activo=1 THEN COALESCE(extra_cupo,0) ELSE 0 END extra FROM tbr_usuario WHERE idusuario=?");
  $st->bind_param('i',$id_usuario); $st->execute();
  $extra = (float)($st->get_result()->fetch_assoc()['extra'] ?? 0); $st->close();

  $sql = "SELECT IFNULL(SUM(t.valor),0) suma
          FROM tbr_ticket t
          INNER JOIN tbr_usuario u ON u.idusuario=t.id_usuario
          WHERE t.fecha=? AND t.condicion=1 AND t.id_cifras=3
            AND t.numero=? AND u.id_sucursal=?";
  $st = $cn->prepare($sql);
  $st->bind_param('ssi',$date2,$number,$id_sucursal);
  $st->execute();
  $suma=(float)($st->get_result()->fetch_assoc()['suma'] ?? 0); $st->close();

  $cupo_total=$cupo_suc+$extra; $restante_total=$cupo_total-$suma;
  if (($suma+$valor)>$cupo_total) {
    echo json_encode(['success'=>false,'error'=>'Cupo_no_disponible','mensaje'=>"No puedes superar el cupo máximo de $cupo_total.",'cupo_restante'=>number_format(max($restante_total,0),2,'.','')]);
    exit;
  }

  $restante_sucursal = max($cupo_suc - $suma, 0);
  $tope1 = min($valor,$restante_sucursal);
  $tope2 = max($valor-$tope1,0);
  if ($tope2 > $extra) throw new Exception("No puedes superar el cupo adicional de $extra.");

  $fecha_imp=date('Y-m-d'); $hora_imp=date('H:i:s');
  $codigo=substr(str_shuffle(str_repeat('0123456789',8)),0,8);
  $estado=1; $cond=1;

  $sql="INSERT INTO tbr_ticket
    (fecha_impreso, hora_impreso, fecha, id_loteria, numero, valor,
     id_usuario, codigo, estado, tope1, tope2, id_cifras, condicion)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
  $st=$cn->prepare($sql);
  $st->bind_param('sssisdisiddii',
    $fecha_imp,$hora_imp,$date2,$idloteria,$number,$valor,
    $id_usuario,$codigo,$estado,$tope1,$tope2,$id_cifras,$cond
  );
  $st->execute();
  $id=$cn->insert_id; $st->close();

  echo json_encode(['success'=>true,'id'=>$id,'codigo'=>$codigo]);
} catch (Throwable $e) {
  echo json_encode(['success'=>false,'message'=>'No se pudo guardar','error'=>$e->getMessage()]);
}
