<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Error: Sesión no iniciada."]);
    exit();
}

$id_usuario = $_SESSION['idusuario'];
$sucursal_id = $_SESSION['sucursal'] ?? null;
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');

if (!isset($conn) || !$conn) {
    echo json_encode(["error" => "No se pudo establecer conexión con la base de datos."]);
    exit();
}

// Sanitización y validación de datos
$sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_VALIDATE_INT) ?: 0;
$rol = filter_input(INPUT_POST, 'rol', FILTER_VALIDATE_INT) ?: 0;
$cupo = filter_input(INPUT_POST, 'cupo', FILTER_VALIDATE_INT) ?: 0;
$cupo3 = filter_input(INPUT_POST, 'cupo3', FILTER_VALIDATE_INT) ?: 0;
$cupo4 = filter_input(INPUT_POST, 'cupo4', FILTER_VALIDATE_INT) ?: 0;
$hora_inicio = filter_input(INPUT_POST, 'hora_inicio', FILTER_SANITIZE_STRING);
$hora_fin = filter_input(INPUT_POST, 'hora_fin', FILTER_SANITIZE_STRING);
$usuario = filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_STRING);
$clave = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);
$activo = 0;
$condicion = 1;
$venta = 1;
$pago = 1;

if (empty($usuario) || empty($clave) || empty($hora_inicio) || empty($hora_fin)) {
    echo json_encode(["error" => "Todos los campos son obligatorios."]);
    exit();
}

// Encriptar la contraseña antes de guardarla
//$hashed_password = password_hash($clave, PASSWORD_DEFAULT);

// Insertar usuario en la base de datos
$sql_insert = "INSERT INTO tbr_usuario (usuario, id_rol, clave, activo, id_sucursal, extra_cupo, extra_cupo3, extra_cupo4, hora_inicio_a, hora_fin_a, id_administrador, venta, pago, condicion) 
               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = mysqli_prepare($conn, $sql_insert);
if (!$stmt) {
    echo json_encode(["error" => "Error en la preparación de la consulta: " . mysqli_error($conn)]);
    exit();
}

mysqli_stmt_bind_param($stmt, "sisiiiiissiiii", $usuario, $rol, $clave, $activo, $sucursal, $cupo, $cupo3, $cupo4, $hora_inicio, $hora_fin, $id_usuario, $venta, $pago, $condicion);
$insert_success = mysqli_stmt_execute($stmt);

if (!$insert_success) {
    echo json_encode(["error" => "Error al insertar el usuario: " . mysqli_error($conn)]);
    exit();
}

$idusuario = mysqli_insert_id($conn);
mysqli_stmt_close($stmt);

if ($idusuario === 0) {
    echo json_encode(["error" => "Error: No se pudo obtener el ID del usuario."]);
    exit();
}

// Enviar respuesta de éxito
echo json_encode(["success" => "Usuario registrado exitosamente.", "idusuario" => $idusuario]);

// Cerrar conexión
mysqli_close($conn);
?>
