<?php
session_start();

// Verificar sesión
if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
    header('Location: index.php');
    exit();
}

$idusuario = (int) $_SESSION['idusuario']; // Asegurar que es entero
$sucursal_id = $_SESSION['sucursal'] ?? null;

include("conex.php"); // Conexión a la base de datos

$cupototal = 0; 
$cupo = 0;
$extra_cupo = 0;

header("Content-Type: application/json");
date_default_timezone_set('America/Guayaquil');

// Verificar conexión a la base de datos
if (!$conn) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos."]);
    exit();
}

// Obtener la fecha actual
$fecha = new DateTime();
$fecha_formateada = $fecha->format('Y-m-d');

// Verificar que la sucursal es válida
if (!$sucursal_id) {
    http_response_code(400);
    echo json_encode(["error" => "Sucursal no válida."]);
    exit();
}

// Obtener el cupo máximo de la sucursal
$query_cupo = "SELECT cupo FROM tbr_sucursal WHERE idsucursal = ? AND activo = 1 AND condicion = 1";
$stmt_cupo = mysqli_prepare($conn, $query_cupo);
mysqli_stmt_bind_param($stmt_cupo, "i", $sucursal_id);
mysqli_stmt_execute($stmt_cupo);
$result_cupo = mysqli_stmt_get_result($stmt_cupo);
$cupos = ($row = mysqli_fetch_assoc($result_cupo)) ? (int) $row['cupo'] : 0;
mysqli_stmt_close($stmt_cupo);

// Consultar extra_cupo del usuario
$query = "SELECT extra_cupo, cupo_activo FROM tbr_usuario WHERE cupo_activo = 1 AND condicion = 1 AND idusuario = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $idusuario);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $extra_cupo = (int) $row['extra_cupo'];
}
mysqli_stmt_close($stmt);

$cupototal = $cupos + $extra_cupo;

// Consulta para obtener los números que superan el cupo total permitido
$query = "SELECT t.numero, SUM(t.valor) AS total_valor, l.loteria
          FROM tbr_ticket AS t
          INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
          INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
          WHERE t.condicion = 1 
          AND t.estado = 2 
		  AND t.id_cifras = 1
          AND u.id_sucursal = ? 
          AND t.fecha = ? 
          GROUP BY t.numero, l.loteria
          HAVING total_valor >= ? 
          ORDER BY t.numero ASC";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "isi", $sucursal_id, $fecha_formateada, $cupototal);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Verificar si hay error en la consulta
if (!$result) {
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta."]);
    exit();
}

// Construcción del array de respuesta
$numeros = [];
while ($row = mysqli_fetch_assoc($result)) {
    $numeros[] = [
        'numero' => str_pad($row['numero'], 2, '0', STR_PAD_LEFT), // Asegurar 2 dígitos
        'loteria' => $row['loteria']
    ];
}

// Responder en JSON
echo json_encode([
    "numeros_superan_cupo" => $numeros
], JSON_UNESCAPED_UNICODE);

// Cerrar conexiones
mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
