<?php
include("../conex.php");
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['idusuario'])) {
	echo json_encode(['success' => false, 'error' => 'Sesi贸n no v谩lida']);
	exit;
}

$idusuario = intval($_SESSION['idusuario']);

$sql = "SELECT idrifa FROM tbr_ticket 
		WHERE id_usuario = ? 
		AND `key` IS NULL 
		AND id_cifras = 1 
		AND condicion = 1";

$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'i', $idusuario);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$ids = [];
while ($row = mysqli_fetch_assoc($result)) {
	$ids[] = $row['idrifa'];
}

echo json_encode(['success' => true, 'ids' => $ids]);
?>
