<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Guayaquil');
ini_set('display_errors','0');
ini_set('log_errors','1');

require_once __DIR__ . '/../conex.php';
require_once __DIR__ . '/qrlib.php';

if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
  echo json_encode(['success' => false, 'message' => 'Sesión no válida']); exit;
}
$idusuario = (int) $_SESSION['idusuario'];
$usuario   = (string) $_SESSION['usuario'];
$sucursal  = (int) $_SESSION['sucursal'];

$id       = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$loteriaG = isset($_GET['loteria']) ? (int) $_GET['loteria'] : 0;

if ($id <= 0) {
  echo json_encode(['success' => false, 'message' => 'ID inválido']); exit;
}

$sql = "SELECT t.idrifa, t.numero, t.valor, t.codigo, t.id_loteria, l.loteria, l.id_premio
        FROM tbr_ticket AS t
        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
        WHERE t.idrifa = ? AND t.id_usuario = ? AND t.id_cifras = 1 AND t.condicion = 1
        LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $id, $idusuario);
$stmt->execute();
$ticketRes = $stmt->get_result();
if ($ticketRes->num_rows === 0) {
  echo json_encode(['success' => false, 'message' => 'Ticket no encontrado o ya procesado']); exit;
}
$ticket = $ticketRes->fetch_assoc();

if ($loteriaG > 0 && (int)$ticket['id_loteria'] !== $loteriaG) {
  echo json_encode([
    'success' => false,
    'message' => 'La lotería seleccionada no coincide con la del ticket',
    'ticket_loteria' => (int)$ticket['id_loteria'],
    'id_premio'        => (int)$ticket['id_premio'],
    'loteria_get'    => $loteriaG
  ]); exit;
}

$id_premio = (int)$ticket['id_premio'];

// KEY solo dígitos
function generateKey(int $length = 11): string {
  $digits = '0123456789'; $out = '';
  for ($i = 0; $i < $length; $i++) { $out .= $digits[random_int(0, strlen($digits) - 1)]; }
  return $out;
}
$key = generateKey(11);

// Actualizar ticket (estado=2, set key)
$update = $conn->prepare("UPDATE tbr_ticket SET estado = 2, `key` = ? WHERE idrifa = ?");
$update->bind_param("si", $key, $id);
$update->execute();

// Generar QR interno
$qrInternalDir = __DIR__ . '/temp/';
if (!is_dir($qrInternalDir)) { @mkdir($qrInternalDir, 0777, true); }
$filename = $qrInternalDir . 'ticket_' . md5($key) . '.png';
QRcode::png($key, $filename, 'L', 3, 2);
if (!file_exists($filename)) {
  echo json_encode(['success' => false, 'message' => 'Error al generar código QR']); exit;
}

// Copiar a público
$publicBase  = rtrim($_SERVER['DOCUMENT_ROOT'] ?? '', '/');
$qrPublicDir = $publicBase . '/rifa_prueba/temp/';
if (!is_dir($qrPublicDir)) { @mkdir($qrPublicDir, 0777, true); }
$qrFileName   = basename($filename);
$qrPublicPath = '/rifa_prueba/temp/' . $qrFileName;
if (!@copy($filename, $qrPublicDir . $qrFileName)) {
  echo json_encode(['success' => false, 'message' => 'No se pudo copiar el QR a carpeta pública']); exit;
}

// Premios/suertes por sucursal del usuario (y por país)
$queryPremios = "SELECT s.idsuerte, s.numero_s, s.suerte, s.valor, s.detalle
                 FROM tbr_suerte AS s
                 INNER JOIN tbr_sucursal AS sc ON sc.idsucursal = s.id_sucursal
                 INNER JOIN tbr_usuario  AS u  ON u.id_sucursal = sc.idsucursal
                 WHERE s.condicion = 1
                   AND s.activar = 1
                   AND s.id_cifras = 1
                   AND u.idusuario = ?
                   AND s.id_premio = ?";
$stmtPremios = $conn->prepare($queryPremios);
$stmtPremios->bind_param("ii", $idusuario, $id_premio);
$stmtPremios->execute();
$resPremios = $stmtPremios->get_result();
$premios = [];
while ($row = $resPremios->fetch_assoc()) { $premios[] = $row; }

// Insertar premios usando idsuerte correcto
if (!empty($premios)) {
  $insert = $conn->prepare("INSERT INTO tbr_ticket_suerte (id_suerte, premio, id_ticket, condicion) VALUES (?, ?, ?, 1)");
  foreach ($premios as $p) {
    $premioCalc = (float)$p['valor'] * (float)$ticket['valor'];
    $idSuerte   = (int)$p['numero_s'];
    $idTicket   = (int)$ticket['idrifa'];
    $insert->bind_param("idi", $idSuerte, $premioCalc, $idTicket);
    $insert->execute();
  }
}

// Logo sucursal
$imagen = '';
$sql_img = $conn->prepare("SELECT imagen FROM tbr_sucursal WHERE idsucursal = ? AND condicion = 1 AND activo = 1 LIMIT 1");
$sql_img->bind_param("i", $sucursal);
$sql_img->execute();
$result_img = $sql_img->get_result();
if ($row_img = $result_img->fetch_assoc()) { $imagen = (string)$row_img['imagen']; }

$ruta_relativa = "img/default.png";
if (!empty($imagen) && file_exists(__DIR__ . "/../" . $imagen)) { $ruta_relativa = $imagen; }

// HTML del ticket
$fechaHora = date('Y/m/d') . ' - ' . date('H:i:s');
ob_start();
?>
<div style="text-align:center;">
  <img src="<?= htmlspecialchars($ruta_relativa) ?>" alt="Logo" style="width:150px;height:auto;margin-bottom:3px;">
  <div style="font-size:14px;">IMPRESO POR: <?= htmlspecialchars($usuario) ?></div>
  <div style="font-size:14px;"><?= $fechaHora ?></div>

  <div style="font-size:30px;"><strong><?= str_pad((string)$ticket['numero'], 2, '0', STR_PAD_LEFT) ?></strong></div>
  <div style="font-size:16px;"><strong><?= htmlspecialchars((string)$ticket['loteria']) ?></strong></div>
  <div style="font-size:18px;"><strong>$<?= number_format((float)$ticket['valor'], 2) ?></strong></div>
  <hr>

  <div style="font-size:12px;text-align:center;">
    <table style="width:100%;border-collapse:collapse;">
      <?php foreach ($premios as $p):
        $premioFmt = number_format(((float)$p['valor'] * (float)$ticket['valor']), 2);
        $suerte    = htmlspecialchars((string)$p['suerte']);
        $detalle   = htmlspecialchars((string)$p['detalle']);
      ?>
      <tr>
        <td style="padding:2px 6px;text-align:right;font-size:12px;"><?= $suerte ?></td>
        <td style="padding:2px 6px;text-align:right;font-size:12px;"><?= '$' . $premioFmt ?></td>
        <td style="padding:2px 6px;text-align:left;font-size:12px;"><?= '→' . $detalle ?></td>
      </tr>
      <?php endforeach; ?>
    </table>
  </div>

  <div style="font-size:18px;">Código: <?= htmlspecialchars((string)$ticket['codigo']) ?></div>
  <div><img src="<?= htmlspecialchars($qrPublicPath) ?>" alt="Código QR" style="max-width:150px;"></div>
  <div style="font-size:18px;">KEY: <?= htmlspecialchars($key) ?></div>

  <h5 class="nota">SI NO GANAS, TIENES OTRA OPORTUNIDAD. LLEVA TU TICKET PARA EL SORTEO MENSUAL.</h5>
  <h5 class="nota">Nota: El equivalente en electrodoméstico y víveres.</h5>
  <h5 class="nota">Caducidad: 8 días.</h5>
</div>
<?php
$htmlTicket = ob_get_clean();

echo json_encode([
  'success'     => true,
  'html'        => $htmlTicket,
  'key'         => $key,
  'loteria_id'  => (int)$ticket['id_loteria'],
  'loteria_txt' => (string)$ticket['loteria']
], JSON_UNESCAPED_UNICODE);
exit;
