<?php
	include("../conex.php");
	session_start();

	// Verifica si la sesión está activa
	if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) 
	{
		header('Location: index.php');
		exit();
	}

	date_default_timezone_set('America/Guayaquil');
	setlocale(LC_TIME, "es_ES.UTF-8"); // Configurar idioma español en sistemas compatibles

	$idusuario = htmlspecialchars($_SESSION['idusuario']);
	$usuario = htmlspecialchars($_SESSION['usuario']);
	$sucursal = htmlspecialchars($_SESSION['sucursal']);
	
	date_default_timezone_set('America/Guayaquil');
	$fecha_actual = date('Y/m/d');
	$time_actual =date("H:m:s");
	
	
	// Consulta optimizada
	$query = "SELECT t.idrifa, t.fecha, t.numero, t.valor, t.codigo, l.loteria
			  FROM tbr_ticket AS t
			  INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
			  WHERE t.id_usuario = $idusuario AND t.key IS NULL AND t.id_cifras = 1 AND t.condicion = 1";
	$result = mysqli_query($conn, $query);
	$tickets = mysqli_fetch_all($result, MYSQLI_ASSOC);

	$consul_image = mysqli_query($conn, "SELECT s.imagen 
										FROM tbr_sucursal as s 
										WHERE s.idsucursal = '$sucursal'
											and s.condicion = 1 
											and s.activo = 1");
    if($row = mysqli_fetch_array($consul_image))
    {
        $imagen = $row['imagen'];        
    }
	//echo $imagen;
	// Función para generar clave única
	if (!function_exists('generateKey')) 
	{
		function generateKey($length = 11) 
		{
			return substr(str_shuffle(str_repeat('0123456789', $length)), 0, $length);
		}
	}

	// Directorio para códigos QR
	$PNG_TEMP_DIR = __DIR__ . '/temp/';
	$PNG_WEB_DIR = 'temp/';
	include "qrlib.php";

	if (!file_exists($PNG_TEMP_DIR)) 
	{
		mkdir($PNG_TEMP_DIR, 0777, true);
	}
?>
<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>Generar Ticket</title>
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
		<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/dayjs@1.10.4/dayjs.min.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/dayjs@1.10.4/locale/es.js"></script>
		<style>
    body { text-align: center; line-height: 0.6; margin: 0; padding: 0; }
    .ticket-container { max-width: 400px; margin: auto; border: 1px solid #ccc; padding: 10px; }
    .numero { font-size: 34px; font-weight: bold; line-height: 0.6; }
    .loteria, .valor, .premios { font-size: 18px; font-weight: bold; line-height: 0.6; }
    .key, .nota { font-size: 14px; font-weight: bold; line-height: 1.0; }
    .premios-container { display: flex; flex-wrap: wrap; justify-content: center; line-height: 0.6; }
    .premios-container div { width: 100%; padding: 2px; }
    .linea-separadora { border-top: 1px dashed black; margin: 8px 0; line-height: 0.6; }
    
    .premios-container {
        display: flex;
        flex-direction: column;
        line-height: 0.6;
    }

    .premio-item {
        display: flex;
        justify-content: space-between;
        margin-bottom: 1px;
        line-height: 0.4;
    }

    .suerte {
        font-weight: bold;
        font-size: 1.0em;
        text-align: right;
        flex: 1;
        line-height: 0.4;
    }

    .valor-detalle {
        color: #0a0a0a;
        font-size: 1.0em;
        margin-left: 20px;
        text-align: left;
        flex: 1;
        line-height: 0.6;
    }
</style>



	</head>
	<body>
		<div class="container">
			<div class="ticket-container">
			    
				<?php 
					foreach ($tickets as $ticket): 
					// Generar una clave única para cada ticket
					$key = generateKey();

					// Guardar la clave en la base de datos
					$sql = "UPDATE tbr_ticket 
							SET estado = 2, `key` = '$key' 
							WHERE idrifa = {$ticket['idrifa']}";
					mysqli_query($conn, $sql);

					// Generar código QR
					$filename = $PNG_TEMP_DIR . 'ticket_' . md5($key) . '.png';
					QRcode::png($key, $filename, 'L', 3, 2);
				?>
				<!--img src="logo.png" alt="Logo" style="max-width: 50px;"-->
				<!--img src="../<?= $imagen; ?>" alt="Logo" style="max-width: 50px;"-->
				<div style="text-align: center;">
					<img src="../<?= $imagen; ?>" alt="Logo" style="width: 150px; height: auto; margin-bottom: 3px;">
					<h5 style="margin: 0; font-size: 14px;">IMPRESO POR: <?= htmlspecialchars($usuario) ?></h5>
				</div>
				<h5><?= "$fecha_actual - $time_actual" ?></h5>
				<!--h5 class="title">Nro.:</h5-->
				<h6 class="numero"><?= str_pad(htmlspecialchars($ticket['numero']), 2, '0', STR_PAD_LEFT) ?></h6>
				<h6 class="loteria"><?= htmlspecialchars($ticket['loteria']) ?></h6>
				<h6 class="valor">$<?= $valo = number_format($ticket['valor'], 2) ?>
				<?php $valodb = $ticket['valor']; ?></h6>

				<div class="premios-container">
					<?php
						// Consulta para obtener los premios del usuario
						$query = "SELECT s.idsuerte, s.numero_s, s.suerte, s.valor, s.detalle
							FROM tbr_suerte as s 
							INNER JOIN tbr_sucursal as sc on sc.idsucursal = s.id_sucursal
							INNER JOIN tbr_usuario as u on u.id_sucursal = sc.idsucursal
							WHERE s.condicion = 1 AND s.activar = 1 AND s.id_cifras = 1 and u.idusuario = ?";

						// Preparar la consulta
						$stmt = mysqli_prepare($conn, $query);
						
						// Enlazar el parámetro
						mysqli_stmt_bind_param($stmt, "i", $idusuario);
						
						// Ejecutar la consulta
						mysqli_stmt_execute($stmt);
						
						// Obtener el resultado
						$result = mysqli_stmt_get_result($stmt);

						// Recorrer los resultados y mostrarlos
						while ($row = mysqli_fetch_assoc($result)) 
						{
							$valort = number_format($row['valor'] * $valo, 2);
							$valordb = $row['valor'] * $valodb;
							
							$numero_s = $row['numero_s'];
							
							echo "<div class='premio-item'>
									<p class='suerte'><strong>{$row['suerte']}</strong></p>
									<p class='valor-detalle'><strong>\${$valort} - {$row['detalle']}</strong></p>
								  </div>";
								  
								// Definir la condición
							$condicion = 1; // O el valor que corresponda en tu lógica

							$sql_insert = "INSERT INTO tbr_ticket_suerte (id_suerte, premio, id_ticket, condicion) VALUES (?, ?, ?, ?)";
							$stmt = mysqli_prepare($conn, $sql_insert);

							// Aquí se deben pasar las variables correctamente sin usar llaves para el valor de `ticket['idrifa']`
							mysqli_stmt_bind_param($stmt, "idis", $numero_s, $valordb, $ticket['idrifa'], $condicion);
							$insert_success = mysqli_stmt_execute($stmt);

							if (!$insert_success) {
								echo json_encode(["error" => "Error al insertar la suerte: " . mysqli_error($conn)]);
								exit();
							}
  
						}
						
						// Cerrar la declaración
						mysqli_stmt_close($stmt);
					?>
				</div>

				<h5 class="loteria">Código: <?= htmlspecialchars($ticket['codigo']) ?></h5>

				<div>
					<img src="<?= htmlspecialchars($PNG_WEB_DIR . basename($filename)) ?>" alt="Código QR" style="max-width: 150px;">
				</div>

				<h5 class="key">KEY: <?= htmlspecialchars($key) ?></h5>
				<h5 class="nota">SI NO GANAS, TIENES OTRA OPORTUNIDAD. LLEVA TU TICKET PARA EL SORTEO MENSUAL.</h5>
				<h5 class="nota">Nota: El equivalente en electrodoméstico y víveres.</h5>
				<h5 class="nota">Caducidad: 8 días.</h5>

				<div class="linea-separadora"></div> <!-- Línea separadora entre tickets -->

				<?php endforeach; ?>
			</div>
		</div>	
		

		<script>
			$(document).ready(function () {
				dayjs.locale('es');

				// Formatear fecha y hora en español
				$('.fecha').text(dayjs().format('dddd, DD MMMM YYYY'));
				$('.hora').text(dayjs().format('HH:mm'));

				// Imprimir y redirigir después de completar la impresión
				setTimeout(function () {
					window.print();
				}, 500); // Espera para asegurar que los datos se actualicen antes de imprimir

				// Detectar cuando la impresión ha terminado y redirigir
				window.onafterprint = function () {
					window.location.href = "../ventas.php";
				};
			});
		</script>


	</body>
</html>
