<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
  header("Location: ../administracion.php");
  exit;
}

$usuario  = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Sistema de Gestión</title>
  <link rel="shortcut icon" href="../resources/img/crud.ico">

  <!-- Bootstrap 5 CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

  <!-- DataTables CSS (Bootstrap 5) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
  <!-- Buttons CSS (Bootstrap 5) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

  <style>
    body {
      background-color: #f4f6f9;
      padding-top: 60px;
      overflow-x: hidden;
    }
    .topbar {
      width: 100%;
      height: 60px;
      background: #343a40;
      color: white;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0 20px;
      position: fixed;
      top: 0; left: 0;
      z-index: 1000;
    }
    .sidebar {
      width: 250px;
      background: #343a40;
      color: #fff;
      padding: 20px;
      height: 100vh;
      position: fixed;
      left: 0;
      top: 60px;
      display: flex;
      flex-direction: column;
      align-items: flex-start;
      transition: width 0.3s;
      z-index: 1000;
    }
    .sidebar a { color: white; text-decoration: none; padding: 12px; display: flex; align-items: center; width: 100%;
      transition: background 0.3s, transform 0.2s; border-radius: 8px; }
    .sidebar a:hover, .sidebar a.active { background: #495057; transform: scale(1.05); }
    .sidebar .submenu { display: none; padding-left: 20px; list-style: none; margin: 0; font-size: 14px; }
    .sidebar .submenu li { padding: 8px 0; }
    .sidebar.collapsed { width: 80px; }
    .sidebar.collapsed a span { display: none; }

    .main-content {
      margin-left: 250px;
      padding: 1rem;
      transition: margin-left 0.3s;
      z-index: 100;
    }

    .toggle-btn { cursor: pointer; margin-right: 10px; }

    /* Botones DataTables */
    .dt-buttons .btn {
      padding: 6px 10px;
      font-size: 14px;
      border-radius: 5px;
      color: white !important;
    }
    .btn-success { background-color: #28a745 !important; border-color: #28a745 !important; }
    .btn-danger  { background-color: #dc3545 !important; border-color: #dc3545 !important; }
  </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
  <div class="toggle-btn" onclick="toggleSidebar()">
    <i class="fas fa-bars"></i>
  </div>
  <span style="margin-left: 20px;">Sistema de Gestión</span>
  <div class="info">
    <span><?php echo htmlspecialchars($usuario); ?></span>
    <span id="fechaActual" class="ms-3"></span>
    <span id="horaActual" class="ms-2"></span>
  </div>
</div>

<!-- Sidebar (si tu menu.php ya renderiza el contenedor, añade el id="sidebar" allí y quita este div) -->
<div class="sidebar" id="sidebar">
  <?php include("menu.php"); ?>
</div>

<!-- Contenido Principal -->
<div class="main-content" id="mainContent">
  <div class="container-fluid">
    <div class="card">
      <div class="card-header">
        <div class="row g-3 align-items-end">
          <div class="col-md-2">
            <label for="fecha_i" class="form-label">Desde*</label>
            <input id="fecha_i" name="fecha_i" type="date" class="form-control" required>
          </div>
          <div class="col-md-2">
            <label for="fecha_f" class="form-label">Hasta*</label>
            <input id="fecha_f" name="fecha_f" type="date" class="form-control" required>
          </div>
          <div class="col-md-3">
            <label for="sucursal" class="form-label">Sucursal*</label>
            <select class="form-control" id="sucursal" name="sucursal" required></select>
          </div>
          <div class="col-md-3">
            <label for="usuario_s" class="form-label">Usuario*</label>
            <select class="form-control" id="usuario_s" name="usuario_s" required></select>
          </div>
        </div>
      </div>

      <div class="card-body">
        <div class="table-responsive">
          <table id="ticket_hoy" class="table table-striped w-100">
            <thead>
              <tr class="text-center">
                <th>Cifras <i class="fas fa-sort-numeric-down"></i></th>
                <th>Sucursal <i class="fas fa-television"></i></th>
                <th>Usuario <i class="fas fa-user"></i></th>
                <th>Fecha <i class="fas fa-calendar"></i></th>
                <th>Sorteo <i class="fas fa-calendar-check"></i></th>
                <th>Número <i class="fas fa-hashtag"></i></th>
                <th>Valor <i class="fas fa-dollar-sign"></i></th>
                <th>Código <i class="fas fa-barcode"></i></th>
                <th>Eliminado <i class="fas fa-ban"></i></th>
                <th>Fecha eliminado <i class="fas fa-clock"></i></th>
              </tr>
            </thead>
            <tbody></tbody>
            <!-- Si no mostrarás totales, no uses tfoot para evitar desajustes de columnas -->
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- DataTables core + Bootstrap 5 -->
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

<!-- Buttons + Bootstrap 5 + dependencias -->
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  // Fecha y hora en topbar
  function actualizarHora() {
    const ahora = new Date();
    const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const opcionesHora  = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
    document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
    document.getElementById('horaActual').textContent  = ahora.toLocaleTimeString('es-ES', opcionesHora);
  }
  setInterval(actualizarHora, 1000);
  actualizarHora();

  // Sidebar toggle
  function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.getElementById('mainContent');
    sidebar.classList.toggle('collapsed');
    mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
  }
  window.toggleSidebar = toggleSidebar;

  // Cargar selects Sucursal y Usuario
  $(document).ready(function() {
    // Sucursales
    $.ajax({
      type: "POST",
      url: "datos.php?Accion=GetSucursal",
      success: function(response) {
        $('#sucursal').html(response).fadeIn();
      }
    });

    // Usuarios por sucursal
    $("#sucursal").on('change', function() {
      var Sucursal = $(this).val();
      $.ajax({
        type: "POST",
        url: "datos.php?Accion=GetUsuario&Sucursal=" + encodeURIComponent(Sucursal),
        success: function(data) {
          $('#usuario_s').html(data).fadeIn();
        }
      });
    });
  });

  // Fechas con zona Ecuador: hoy y hoy-15
  document.addEventListener("DOMContentLoaded", function() {
    function formatGye(date) {
      // Formatea YYYY-MM-DD en zona America/Guayaquil
      return new Intl.DateTimeFormat("sv-SE", {
        timeZone: "America/Guayaquil",
        year: "numeric", month: "2-digit", day: "2-digit"
      }).format(date);
    }
    const now = new Date();
    const fechaHoy = formatGye(now);

    const hace15 = new Date(now);
    hace15.setDate(hace15.getDate() - 15);
    const fechaDesde = formatGye(hace15);

    const fechaI = document.getElementById("fecha_i");
    const fechaF = document.getElementById("fecha_f");
    if (fechaI) { fechaI.value = fechaDesde; fechaI.min = fechaDesde; fechaI.max = fechaHoy; }
    if (fechaF) { fechaF.value = fechaHoy;   fechaF.min = fechaDesde; fechaF.max = fechaHoy; }

    if (fechaI && fechaF) {
      fechaI.addEventListener("change", function() {
        fechaF.min = fechaI.value;
        if (fechaF.value < fechaI.value) fechaF.value = fechaI.value;
      });
    }
  });

  // DataTable
  $(function () {
    const tabla = $('#ticket_hoy').DataTable({
      processing: true,
      serverSide: false,
      ajax: {
        // ⬇️ EXACTAMENTE como pediste:
        url: 'tickets_eliminados_list.php',
        data: function (d) {
          d.fecha_i = $('#fecha_i').val();
          d.fecha_f = $('#fecha_f').val();
          d.sucursal = $('#sucursal').val();
          d.usuario  = $('#usuario_s').val();
        },
        dataSrc: 'data',
        error: function (xhr) {
          console.error('Error cargando datos', xhr?.responseText || xhr?.statusText);
          Swal.fire('Error', 'No se pudo cargar la tabla', 'error');
        }
      },
      columns: [
        { data: 'cifras',  className: 'text-center' },
        { data: 'sucursal', className: 'text-center' },
        { data: 'usuario',  className: 'text-center' },
        { data: 'fecha',    className: 'text-center' },     // Impreso (Ecuador)
        { data: 'sorteo',   className: 'text-center' },     // Lotería
        { data: 'numero',   className: 'text-center' },
        { data: 'valor',    className: 'text-end' },
        { data: 'codigo',   className: 'text-center' },
        { data: 'eliminado', className: 'text-center' },
        { data: 'fecha_eliminado', className: 'text-center' }
      ],
      order: [[3, 'desc']],
      pageLength: 25,
      dom: 'Bfrtip',
      buttons: [
        { extend: 'excelHtml5', className: 'btn btn-success', text: '<i class="fa fa-file-excel"></i> Excel' },
        { extend: 'print',      className: 'btn btn-primary', text: '<i class="fa fa-print"></i> Imprimir' }
      ],
      language: { url: 'https://cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json' }
    });

    // Recargar cuando cambien filtros
    $('#fecha_i, #fecha_f, #sucursal, #usuario_s').on('change', function () {
      tabla.ajax.reload();
    });
  });

  // Cerrar sesión con confirmación
  function cerrar() {
    Swal.fire({
      title: '¿Estás seguro?',
      text: '¿Deseas cerrar sesión?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Sí, cerrar sesión',
      cancelButtonText: 'Cancelar'
    }).then((result) => {
      if (result.isConfirmed) {
        fetch('../../controllers/usuario.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: new URLSearchParams({ boton: 'cerrar' })
        })
        .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
        .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
      }
    });
  }
  window.cerrar = cerrar;
</script>

</body>
</html>
