<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden; /* Evitar desplazamiento horizontal */
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
            z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
        }

        .modal-backdrop {
            z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
        }

        .modal-dialog {
            z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        /* Ajustar la visibilidad del sidebar al colapsar */
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }
		
		/* Estilos del interruptor */
	.switch {
	  position: relative;
	  display: inline-block;
	  width: 60px;
	  height: 34px;
	}

	.switch input {
	  opacity: 0;
	  width: 0;
	  height: 0;
	}
	.slider {
	  position: absolute;
	  cursor: pointer;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: #ccc;
	  transition: 0.4s;
	  border-radius: 34px;
	}

	.slider:before {
	  position: absolute;
	  content: "";
	  height: 26px;
	  width: 26px;
	  border-radius: 50%;
	  left: 4px;
	  bottom: 4px;
	  background-color: white;
	  transition: 0.4s;
	}

	input:checked + .slider {
	  background-color: #4CAF50;
	}

	input:checked + .slider:before {
	  transform: translateX(26px);
	}
	
	.dt-buttons .btn {
    padding: 6px 10px;
    font-size: 16px;
    border-radius: 5px;
    color: white !important;  /* Asegurar color del texto */
		}

		.btn-success {
			background-color: #28a745 !important;
			border-color: #28a745 !important;
		}

		.btn-danger {
			background-color: #dc3545 !important;
			border-color: #dc3545 !important;
		}

    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo $usuario; ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
					<div class="col-lg-2 col-md-2">
						<div class="form-group">
							<label for="fecha_i">Desde*</label>
							<input id="fecha_i" name="fecha_i" type="date" class="form-control border-left-0" required>
						</div>						
					</div>
					
					<div class="col-lg-2 col-md-2">
						<div class="form-group">
							<label for="fecha">Hasta*</label>
							<input id="fecha_f" name="fecha_f" type="date" class="form-control border-left-0" required>
						</div>						
					</div>
					
                    <div class="col-lg-2 col-md-2">
						<div class="form-group">
							<label for="sucursal">Sucursal*</label>
							<select class="form-control" id="sucursal" name="sucursal" required></select>
						</div>
					</div> 
					<div class="col-lg-2 col-md-2">
						<div class="form-group">
							<label for="usuario_s">Usuario*</label>
							<select class="form-control" id="usuario_s" name="usuario_s" required></select>
						</div>
					</div> 
                    <div class="modal-body p-2"> <!-- Quitamos el padding para que la tabla ocupe todo -->
						<div class="table-responsive"> <!-- Contenedor para hacer la tabla adaptable -->
							<table id="ticket_hoy" class="table table-striped w-100 m-0"> <!-- Ancho completo y sin margen -->
								<thead>
									<tr class="text-center">
										<th>Cifras <i class="fas fa-sort-numeric-down"></i></th>
										<th>Fecha<i class="fas fa-calendar"></i></th>
										<th>Sucursal <i class="fas fa-television"></i></th>
										<th>Usuario <i class="fas fa-user"></i></th>										
										<th>Ventas <i class="fas fa-dollar-sign"></i></th>
										<th>Premio <i class="fas fa-trophy"></i></th>
										<th>Utilidad/Perdida <i class="fas fa-dollar-sign"></i></th>
									</tr>
								</thead>
								<tbody>
									<!-- Aquí puedes cargar más datos dinámicamente -->
								</tbody>
								<tfoot>
									<tr>
										<th></th>										
										<th colspan="1">UTILIDAD DEL DÍA</th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>                       
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Asegúrate de que los scripts necesarios estén cargados -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
	<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
	<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
	<script src="../../resources/js/menu_r_up.js"></script>
	<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
	<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
	<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script>
    // Función para actualizar la fecha y hora en la barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();
    
    // Función para alternar la visibilidad del sidebar
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }

	//funcio para cerra sesion
	function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }
	$(document).ready(function() {
		// Cargar las opciones de sucursal
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetSucursal",  // URL de la API para obtener las sucursales
			success: function(response) {
				$('#sucursal').html(response).fadeIn();
			}
		});

		// Cargar los usuarios basados en la sucursal seleccionada
		$("#sucursal").change(function() {
			var Sucursal = $(this).val();
			
			$.ajax({
				type: "POST",
				url: "datos.php?Accion=GetUsuario&Sucursal=" + Sucursal,  // URL para obtener usuarios según la sucursal
				success: function(data) {
					$('#usuario_s').html(data).fadeIn();
				}
			});
		});
	});
	
	document.addEventListener("DOMContentLoaded", function() {
		function setDateRestrictions(inputId) {
			let now = new Date();

			// Obtener la fecha actual en la zona horaria de Guayaquil
			let ecuadorTime = new Intl.DateTimeFormat("sv-SE", { 
				timeZone: "America/Guayaquil", 
				year: "numeric", 
				month: "2-digit", 
				day: "2-digit" 
			}).format(now);

			// Calcular la fecha de hace 15 días
			/*now.setDate(now.getDate() - 15);
			let minDate = new Intl.DateTimeFormat("sv-SE", { 
				timeZone: "America/Guayaquil", 
				year: "numeric", 
				month: "2-digit", 
				day: "2-digit" 
			}).format(now);*/

			// Asignar valores al input de fecha
			let dateInput = document.getElementById(inputId);
			if (dateInput) {
				dateInput.value = ecuadorTime; // Fecha actual por defecto
				dateInput.max = ecuadorTime;   // Máximo: hoy
				dateInput.min = minDate;       // Mínimo: hace 15 días
			}
		}

		// Aplicar restricciones a ambos inputs
		setDateRestrictions("fecha_i");
		setDateRestrictions("fecha_f");

		// Agregar restricción dinámica a `fecha_f` basada en `fecha_i`
		let fechaI = document.getElementById("fecha_i");
		let fechaF = document.getElementById("fecha_f");

		if (fechaI && fechaF) {
			fechaI.addEventListener("change", function() {
				fechaF.min = fechaI.value; // `fecha_f` no puede ser menor que `fecha_i`

				// Si la fecha seleccionada en `fecha_f` es menor que `fecha_i`, la ajusta
				if (fechaF.value < fechaI.value) {
					fechaF.value = fechaI.value;
				}
			});
		}
	});


</script>

</body>
</html>
