<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden; /* Evitar desplazamiento horizontal */
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
            z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
        }

        .modal-backdrop {
            z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
        }

        .modal-dialog {
            z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        /* Ajustar la visibilidad del sidebar al colapsar */
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }
		
		/* Estilos del interruptor */
	.switch {
	  position: relative;
	  display: inline-block;
	  width: 60px;
	  height: 34px;
	}

	.switch input {
	  opacity: 0;
	  width: 0;
	  height: 0;
	}
	.slider {
	  position: absolute;
	  cursor: pointer;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: #ccc;
	  transition: 0.4s;
	  border-radius: 34px;
	}

	.slider:before {
	  position: absolute;
	  content: "";
	  height: 26px;
	  width: 26px;
	  border-radius: 50%;
	  left: 4px;
	  bottom: 4px;
	  background-color: white;
	  transition: 0.4s;
	}

	input:checked + .slider {
	  background-color: #4CAF50;
	}

	input:checked + .slider:before {
	  transform: translateX(26px);
	}

    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo $usuario; ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-md-12"> 
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregar">Agregar Sorteo</button>
                    </div>
                    
                    <div class="col-md-12">    
                        <table id="usuar" class="table table-hover" cellspacing="0" width="100%">
                            <thead>
                                <tr class="info">                                                                                                 
                                    <th>Fecha</th>
                                    <th>Suerte</th>
                                    <th>Número</th>
                                    <th>Loteria</th>
                                    <th>Activo</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Aquí se carga dinámicamente el contenido -->
                            </tbody>
                        </table>        
                    </div>                         
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="agregar" tabindex="-1" aria-labelledby="agregar_empresaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="agregarLabel">Agregar nuevo sorteo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
			
            <div class="modal-body">
                <!-- Formulario de agregar usuario -->
                <form id="formAgregarUsuario">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="premio">Fecha*</label>
								<input name="fecha" id="fecha" type="date" class="form-control" required>								
							</div>
						</div>						
						 <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="loteria">Loteria*</label>
								<select name="loteria" id="loteria" class="form-control" placeholder="Selecciona la Loteria..." required></select>                                
                            </div>
                        </div> 						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">                                
								<label for="suerte">Suerte*</label>
								<select class="form-control" id="suerte" name="suerte" required></select>
								<script>
									const selectSuerte = document.getElementById("suerte");
									const opcionesSuerte = [
										"PRIMERA", "SEGUNDA", "TERCERA", "CUARTA", "QUINTA",
										"SEXTA", "SEPTIMA", "OCTAVA", "NOVENA", "DECIMA"
									];

									opcionesSuerte.forEach((texto, index) => {
										let option = document.createElement("option");
										option.value = index + 1;  // Ahora el index está definido
										option.textContent = texto;
										selectSuerte.appendChild(option);
									});
								</script>                                
							</div>
						</div>						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="number">Número*</label>
								<input type="number" class="form-control" id="numero" name="numero" required>
							</div>
						</div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="guardar()">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para editar -->
<div id="modalEditar" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditarLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarLabel">Editar Usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>                    
            </div>
            <div class="modal-body">
                <form id="formEditar">
					<div class="row">
						<input type="hidden" id="idsorteo_a" name="idsorteo_a">
						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="premio">Fecha*</label>
								<input name="fecha_a" id="fecha_a" type="date" class="form-control" required>								
							</div>
						</div>
						
						 <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="loteria">Loteria*</label>
								<select name="loteria_a" id="loteria_a" class="form-control" placeholder="Selecciona la Loteria..." required></select>                                
                            </div>
                        </div> 
						
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="suerte">Suerte*</label>
								<select class="form-control" id="suerte_a" name="suerte_a" required></select>
								<script>
									const selectSuerte_a = document.getElementById("suerte_a");
									const opcionesSuerte_a = [
										"PRIMERA", "SEGUNDA", "TERCERA", "CUARTA", "QUINTA",
										"SEXTA", "SEPTIMA", "OCTAVA", "NOVENA", "DECIMA"
									];

									// Iterar correctamente sobre las opciones
									opcionesSuerte_a.forEach((texto, index) => {
										let option = document.createElement("option");
										option.value = index + 1;  // Establecer el valor de la opción
										option.textContent = texto;
										selectSuerte_a.appendChild(option); // Agregar al select
									});
								</script>
							</div>
						</div>

						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="number">Número*</label>
								<input type="number" class="form-control" id="numero_a" name="numero_a" required>
							</div>
						</div>
					</div>					
                </form>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				<button type="submit" class="btn btn-primary" onclick="actualizar()">Guardar Cambios</button>
			</div>
        </div>
    </div>
</div>


<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Asegúrate de que los scripts necesarios estén cargados -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
	<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
	<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
	<script src="../../resources/js/menu_sorteo.js"></script>
<script>
    // Función para actualizar la fecha y hora en la barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();
    
    // Función para alternar la visibilidad del sidebar
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }
	
		
	//funcion para desactivar y activar sorteo	
	$(document).on("change", ".toggle-switch", function () {
		let switchElement = $(this);
		let idsorteo = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "actulizar_estado_sor.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idsorteo: idsorteo, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);				
				} 
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
		
	//funcion para bloquear usuario	
	$(document).ready(function () {
		$(document).on("click", ".toggle-condicion", function () {
			let boton = $(this);
			let idsorteo = boton.data("id");

			Swal.fire({
				title: "¿Estás seguro?",
				text: "El sorteo será eliminado.",
				icon: "warning",
				showCancelButton: true,
				confirmButtonColor: "#d33",
				cancelButtonColor: "#3085d6",
				confirmButtonText: "Sí, eliminar",
				cancelButtonText: "Cancelar"
			}).then((result) => {
				if (result.isConfirmed) {
					$.ajax({
						url: "actualizar_condicion_sor.php",
						type: "POST",
						data: { idsorteo: idsorteo },
						dataType: "json",
						success: function (response) {
							if (response.success) {
								Swal.fire({
									icon: "success",
									title: "Sorteo eliminada",
									text: "El sorteo ha sido eliminado correctamente.",
									timer: 3000
								});

								// Recargar la tabla automáticamente
								$("#usuar").DataTable().ajax.reload(null, false);
							} else {
								Swal.fire("Error", "No se pudo eliminar.", "error");
							}
						},
						error: function () {
							Swal.fire("Error", "Error de conexión con el servidor.", "error");
						}
					});
				}
			});
		});
	});
		
    // Función para guardar el sorteo (aquí debes agregar la lógica de envío del formulario)
    function guardar() 
	{
		var fecha = $('#fecha').val();
		var loteria = $('#loteria').val();
		var suerte = $('#suerte').val();
		var numero = $('#numero').val();		

		// Validar que todos los campos estén llenos
		if (!fecha || !loteria || !suerte || !numero) {
			Swal.fire("Error","Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		
		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_sorteo.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				fecha: fecha,
				loteria: loteria,
				suerte: suerte,
				numero: numero
			},
			beforeSend: function () {
				// Puedes deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="guardar()"]').prop('disabled', true);
			},
			success: function (response) {
				
				Swal.fire({
							title: 'Éxito',
							text: 'El sorteo fue guardado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});				
			},
			error: function (xhr, status, error) {
				
				Swal.fire("Error","Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				$('button[onclick="guardar()"]').prop('disabled', false); // Rehabilitar botón
			}
		});
	}
	
	//funcion para editar registro de usuario
	$(document).on('click', '.toggle-editar', function() 
	{
		var idsorteo_a = $(this).data('id');
		var fecha_a = $(this).data('fecha');
		var loteria_a = $(this).data('id_loteria');
		var suerte_a = $(this).data('suerte');
		var numero_a = $(this).data('numero');		
		//alert (suerte_a); 
		// Cargar los datos en un formulario de edición o modal
		$('#idsorteo_a').val(idsorteo_a);
		$('#fecha_a').val(fecha_a);
		$('#loteria_a').val(loteria_a);
		$('#suerte_a').val(suerte_a);
		$('#numero_a').val(numero_a);
		
		// Mostrar el modal o formulario
		$('#modalEditar').modal('show');
	});

	function actualizar() {
		// Obtener los valores de los campos
		var idsorteo_a = $('#idsorteo_a').val();
		var fecha_a = $('#fecha_a').val();
		var loteria_a = $('#loteria_a').val();
		var suerte_a = $('#suerte_a').val();
		var numero_a = $('#numero_a').val();		
		
		//alert(suerte_a);
		
		// Validar que todos los campos estén llenos
		if (!numero_a || !fecha_a || !loteria_a || !suerte_a) {
			Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_edicion_sor.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				idsorteo_a: idsorteo_a,
				fecha_a: fecha_a,
				loteria_a: loteria_a,
				suerte_a: suerte_a,
				numero_a: numero_a
			},
			beforeSend: function () {
				// Deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="actualizar()"]').prop('disabled', true);
			},
			success: function (response) {
				//alert(response);
				Swal.fire({
							title: 'Éxito',
							text: 'El premio fue actualizado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});

			},
			error: function (xhr, status, error) {
				Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				// Rehabilitar el botón después de completar la solicitud
				$('button[onclick="actualizar()"]').prop('disabled', false);
			}
		});
	}
</script>
<script>
	//configuracion de del imput de fecha y loteria
	$(document).ready(function() {
			$('#fecha').change(function() { // Ejecutar solo cuando cambie la fecha
				var date = $(this).val(); // Obtener el valor del input

				if (date !== "") { // Verificar si la fecha no está vacía
					$.ajax({
						type: "POST",
						url: "datos.php?Accion=GetLoteriasorteo",
						data: { "fecha": date }, // Coincidir con el nombre en PHP
						success: function(response) {
							$('#loteria').html(response).fadeIn();
						},
						error: function(xhr, status, error) {
							console.error("Error en la solicitud AJAX:", error);
						}
					});
				}
			});
		});
		$(document).ready(function() {			
			//var date = $(this).val(); // Obtener el valor del input
			//var date = '2025-03-05';
			let date = $('#fecha').val(); 
			if (date !== "") { // Verificar si la fecha no está vacía
				$.ajax({
					type: "POST",
					url: "datos.php?Accion=GetLoteriasorteo",
					data: { "fecha": date }, // Coincidir con el nombre en PHP
					success: function(response) {
						$('#loteria').html(response).fadeIn();
					},
					error: function(xhr, status, error) {
						console.error("Error en la solicitud AJAX:", error);
					}
				});
			}			
		});

   document.addEventListener("DOMContentLoaded", function () {
    let fechaInput = document.getElementById("fecha");
    if (!fechaInput) return; // Evita errores si el elemento no existe

    let hoy = new Date();
    let haceOchoDias = new Date();
    haceOchoDias.setDate(hoy.getDate() - 8);

    let formatoFecha = (fecha) => {
        let dd = String(fecha.getDate()).padStart(2, '0');
        let mm = String(fecha.getMonth() + 1).padStart(2, '0'); // Enero es 0
        let yyyy = fecha.getFullYear();
        return `${yyyy}-${mm}-${dd}`;
    };

    fechaInput.max = formatoFecha(hoy);
    fechaInput.min = formatoFecha(haceOchoDias);
    fechaInput.value = formatoFecha(hoy); // Preselecciona la fecha de hoy
});
</script>
<script>
$(document).ready(function() {
    // Evento para detectar cambios en la fecha
    $(document).on('change', '#fecha_a', function() {
        var date = $(this).val().trim();
        
        // Verificar que la fecha no esté vacía y tenga el formato correcto
        if (date === "" || !/^\d{4}-\d{2}-\d{2}$/.test(date)) {
            console.error("Fecha vacía o formato incorrecto");
            return;
        }

        // Limpiar el contenido de #loteria_a antes de hacer la nueva solicitud
        $('#loteria_a').html('<p>Cargando...</p>'); // Mensaje de carga

        console.log("Fecha seleccionada: " + date); // Depuración: fecha seleccionada

        // Hacer la solicitud AJAX cuando la fecha cambie
        $.ajax({
            type: "POST",
            url: "datos.php?Accion=GetLoteriasorteo",
            data: { "fecha": date },
            success: function(response) {
                // Log de respuesta para depurar
                console.log("Respuesta recibida:", response);

                // Verificar que la respuesta no esté vacía
                if (response.trim() === "") {
                    console.error("La respuesta del servidor está vacía.");
                    $('#loteria_a').html('<p>No se encontraron resultados para esta fecha.</p>');
                } else {
                    // Actualizar el contenido de #loteria_a con la respuesta
                    $('#loteria_a').html(response).fadeIn();
                }
            },
            error: function(xhr, status, error) {
                // Depuración: mostrar error en consola
                console.error("Error en la solicitud AJAX:", error);
                $('#loteria_a').html('<p>Error al cargar los datos. Intenta de nuevo.</p>');
            }
        });
    });

    // Configuración del input de fecha al cargar la página
    let fechaInput = document.getElementById("fecha_a");
    if (fechaInput) {
        let hoy = new Date();
        let haceOchoDias = new Date();
        haceOchoDias.setDate(hoy.getDate() - 8);

        let formatoFecha = (fecha) => fecha.toISOString().split("T")[0];

        fechaInput.max = formatoFecha(hoy);
        fechaInput.min = formatoFecha(haceOchoDias);

        // Preseleccionar la fecha de hoy si el campo está vacío
        if (!fechaInput.value) {
            fechaInput.value = formatoFecha(hoy);
        }

        // Si ya hay una fecha seleccionada al cargar, hacer la solicitud AJAX
        let date = fechaInput.value;
        if (date !== "") {
            console.log("Fecha inicial al cargar: " + date); // Depuración
            $.ajax({
                type: "POST",
                url: "datos.php?Accion=GetLoteriasorteo",
                data: { "fecha": date },
                success: function(response) {
                    console.log("Respuesta inicial recibida:", response); // Depuración
                    if (response.trim() === "") {
                        console.error("La respuesta del servidor está vacía.");
                        $('#loteria_a').html('<p>No se encontraron resultados para esta fecha.</p>');
                    } else {
                        $('#loteria_a').html(response).fadeIn();
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la solicitud AJAX:", error);
                    $('#loteria_a').html('<p>Error al cargar los datos. Intenta de nuevo.</p>');
                }
            });
        }
    }
});
	//funcio para cerra sesion
	function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }
</script>

</body>
</html>
