<?php
session_start();
include("conex.php");
$usuario = $_SESSION['usuario'];
$idusuario = $_SESSION['idusuario'];
$sucursal = $_SESSION['sucursal'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 60px;
            overflow-x: hidden; /* Evitar desplazamiento horizontal */
        }

        .topbar {
            width: 100%;
            height: 60px;
            background: #343a40;
            color: white;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar {
            width: 250px;
            background: #343a40;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 60px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            transition: width 0.3s;
            z-index: 1000; /* Asegura que el sidebar tenga un z-index menor que el modal */
        }

        .main-content {
            margin-left: 250px;
            padding: 1rem;
            transition: margin-left 0.3s; /* Para cuando se colapse el sidebar */
            z-index: 100; /* Asegura que el contenido principal no se desorganice al mostrar el modal */
        }

        .modal-backdrop {
            z-index: 1040 !important; /* Asegura que el fondo del modal esté por encima del sidebar */
        }

        .modal-dialog {
            z-index: 1050 !important; /* Asegura que el contenido del modal esté por encima del sidebar */
        }

        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .toggle-btn {
            cursor: pointer;
            margin-right: 10px;
        }

        /* Ajustar la visibilidad del sidebar al colapsar */
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 12px;
            display: flex;
            align-items: center;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
            border-radius: 8px;
        }

        .sidebar .submenu {
            display: none;
            padding-left: 20px;
            list-style: none;
            margin: 0;
            font-size: 14px;
        }

        .sidebar .submenu li {
            padding: 8px 0;
        }

        .sidebar a:hover, .sidebar a.active {
            background: #495057;
            transform: scale(1.05);
        }
		
		/* Estilos del interruptor */
	.switch {
	  position: relative;
	  display: inline-block;
	  width: 60px;
	  height: 34px;
	}

	.switch input {
	  opacity: 0;
	  width: 0;
	  height: 0;
	}
	.slider {
	  position: absolute;
	  cursor: pointer;
	  top: 0;
	  left: 0;
	  right: 0;
	  bottom: 0;
	  background-color: #ccc;
	  transition: 0.4s;
	  border-radius: 34px;
	}

	.slider:before {
	  position: absolute;
	  content: "";
	  height: 26px;
	  width: 26px;
	  border-radius: 50%;
	  left: 4px;
	  bottom: 4px;
	  background-color: white;
	  transition: 0.4s;
	}

	input:checked + .slider {
	  background-color: #4CAF50;
	}

	input:checked + .slider:before {
	  transform: translateX(26px);
	}

    </style>
</head>
<body>

<!-- Barra Superior -->
<div class="topbar">
    <div class="toggle-btn" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </div>
    <span style="margin-left: 20px;">Sistema de Gestión</span>
    <div class="info">
        <span><?php echo $usuario; ?></span>
        <span id="fechaActual"></span>
        <span id="horaActual"></span>
    </div>
</div>

<!-- Sidebar -->
<?php include("menu.php"); ?>

<!-- Contenido Principal -->
<div class="main-content">
    <div class="col-lg-12 col-md-12">
        <div class="panel panel-WHITE">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-md-12"> 
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregar">Agregar Suerte</button>
                    </div>
                    
                    <div class="col-md-12">    
                        <table id="usuar" class="table table-hover" cellspacing="0" width="100%">
                            <thead>
                                <tr class="info">                                                                                                 
                                    <th>Loteria</th>
                                    <th>Cifras</th>
                                    <th>Suerte</th>
                                    <th>Valor</th>
                                    <th>Premio</th>
                                    <th>Sucursal</th>
                                    <th>Activo</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Aquí se carga dinámicamente el contenido -->
                            </tbody>
                        </table>        
                    </div>                         
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="agregar" tabindex="-1" aria-labelledby="agregar_empresaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="agregarLabel">Agregar nueva suerte</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
			
            <div class="modal-body">
                <!-- Formulario de agregar usuario -->
                <form id="formAgregarUsuario">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="loteria">Loteria*</label>
                                <select class="form-control" id="loteria" name="loteria" required></select>
                            </div>
                        </div> 
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="suerte">Suerte*</label>
								<select class="form-control" id="suerte" name="suerte" required></select>
								<script>
									const selectSuerte = document.getElementById("suerte");
									const opcionesSuerte = [
										"PRIMERA", "SEGUNDA", "TERCERA", "CUARTA", "QUINTA", 
										"SEXTA", "SEPTIMA", "OCTAVA", "NOVENA", "DECIMA"
									];

									opcionesSuerte.forEach(texto => {
										let option = document.createElement("option");
										option.value = texto;  // El value es igual al texto
										option.textContent = texto;
										selectSuerte.appendChild(option);
									});
								</script>
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="cifras">Cifras*</label>
                                <select class="form-control" id="cifras" name="cifras" required></select>
                            </div>
                        </div> 
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="valor">Valor*</label>
								<input type="number" class="form-control" id="valor" name="valor" required>
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="premio">Premio*</label>
								<select class="form-control" id="premio" name="premio" required></select>
								<script>
									const selectPremio = document.getElementById("premio");
									const opcionesPremio = [
										"VIVERES", "ELECTRODOMÉSTICO", "EFECTIVO", ""
									];

									opcionesPremio.forEach(texto => {  // Corrección del error aquí
										let option = document.createElement("option");
										option.value = texto.trim();  // Elimina espacios innecesarios
										option.textContent = texto.trim();
										selectPremio.appendChild(option);
									});
								</script>
							</div>
						</div>
                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="sucursal">Sucursal*</label>
                                <select class="form-control" id="sucursal" name="sucursal" required></select>
                            </div>
                        </div>                        
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="guardar()">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para editar -->
<div id="modalEditar" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalEditarLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarLabel">Editar Usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>                    
            </div>
            <div class="modal-body">
                <form id="formEditar">
					<div class="row">
						<input type="hidden" id="idsuerte_a" name="idsuerte_a">
						<div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="loteria">Loteria*</label>
                                <select class="form-control" id="loteria" name="loteria" required></select>
                            </div>
                        </div>
						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="suerte">Suerte*</label>
								<select class="form-control" id="suerte_a" name="suerte_a" required></select>
								<script>
									const selectSuerte_a = document.getElementById("suerte_a");
									const opcionesSuerte_a = [
										"PRIMERA", "SEGUNDA", "TERCERA", "CUARTA", "QUINTA",
										"SEXTA", "SEPTIMA", "OCTAVA", "NOVENA", "DECIMA"
									];

									opcionesSuerte_a.forEach(texto => {
										let option = document.createElement("option");
										option.value = texto;  // El value es igual al texto
										option.textContent = texto;
										selectSuerte_a.appendChild(option);
									});
								</script>
							</div>
						</div>
						<div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="cifras">Cifras*</label>
                                <select class="form-control" id="cifras_a" name="cifras_a" required></select>
                            </div>
                        </div> 
                        <div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="valor">Valor*</label>
								<input type="number" class="form-control" id="valor_a" name="valor_a" required>
							</div>
						</div>

						<div class="col-lg-6 col-md-6">
							<div class="form-group">
								<label for="premio">Premio*</label>
								<select class="form-control" id="premio_a" name="premio_a" required></select>
								<script>
									const selectPremio_a = document.getElementById("premio_a");
									const opcionesPremio_a = [
										"VIVERES", "ELECTRODOMÉSTICO", "EFECTIVO", ""
									];

									opcionesPremio_a.forEach(texto => {  // Corrección del error aquí
										let option = document.createElement("option");
										option.value = texto.trim();  // Elimina espacios innecesarios
										option.textContent = texto.trim();
										selectPremio_a.appendChild(option);
									});
								</script>
							</div>
						</div>

                        <div class="col-lg-6 col-md-6">
                            <div class="form-group">
                                <label for="sucursal">Sucursal*</label>
                                <select class="form-control" id="sucursal_a" name="sucursal_a" required></select>
                            </div>
                        </div>      
					</div>					
                </form>
            </div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				<button type="submit" class="btn btn-primary" onclick="actualizar()">Guardar Cambios</button>
			</div>
        </div>
    </div>
</div>


<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!-- Asegúrate de que los scripts necesarios estén cargados -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
	<script src="../../resources/media/js/jquery.dataTables.min.js"></script>
	<script src="../../resources/media/js/dataTables.bootstrap.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
	<script src="../../resources/js/menu_suerte.js"></script>
<script>
    // Función para actualizar la fecha y hora en la barra superior
    function actualizarHora() {
        const ahora = new Date();
        const opcionesFecha = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
        const opcionesHora = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
        document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opcionesFecha);
        document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opcionesHora);
    }
    setInterval(actualizarHora, 1000);
    actualizarHora();
    
    // Función para alternar la visibilidad del sidebar
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        sidebar.classList.toggle('collapsed');
        mainContent.style.marginLeft = sidebar.classList.contains('collapsed') ? '80px' : '250px';
    }
	
		
	//funcion para desactivar y activar usuario	
	$(document).on("change", ".toggle-switch", function () {
		let switchElement = $(this);
		let idsuerte = switchElement.data("id");
		let estado_actual = switchElement.data("estado");
		
		$.ajax({
			url: "actulizar_estado_sr.php", // Archivo que actualizará el estado
			type: "POST",
			data: { idsuerte: idsuerte, estado: estado_actual },
			dataType: "json",
			success: function (response) {
				if (response.success) {
					// Recargar la tabla automáticamente
					$("#usuar").DataTable().ajax.reload(null, false);				
				} 
			},
			error: function () {
				$('#error-msg').text("Error de conexión con el servidor.").show();
				//alert("Error de conexión con el servidor.");
			}
		});
	});
	
	//funcion para bloquear usuario	
	$(document).ready(function () {
    $(document).on("click", ".toggle-condicion", function () {
        let boton = $(this);
        let idsuerte = boton.data("id");

        Swal.fire({
            title: "¿Estás seguro?",
            text: "la suerte será eliminada.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#3085d6",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar"
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "actualizar_condicion_sr.php",
                    type: "POST",
                    data: { idsuerte: idsuerte },
                    dataType: "json",
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: "success",
                                title: "Suerte eliminada",
                                text: "La suerte ha sido eliminado correctamente.",
                                timer: 3000
                            });

                            // Recargar la tabla automáticamente
                            $("#usuar").DataTable().ajax.reload(null, false);
                        } else {
                            Swal.fire("Error", "No se pudo eliminar.", "error");
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Error de conexión con el servidor.", "error");
                    }
                });
            }
        });
    });
});
	//Funcion premio seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetLote",
			
			success: function(response)
			{
				$('#loteria').html(response).fadeIn();
			}
		}); 
	});
	
	//Funcion sucursal seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetSucursal",
			
			success: function(response)
			{
				$('#sucursal').html(response).fadeIn();
			}
		}); 
	});
	
	//Funcion cifras seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetCifras",
			
			success: function(response)
			{
				$('#cifras').html(response).fadeIn();
			}
		}); 
	});
	
	//Funcion sucursal seleccion		
	$(document).ready(function() 
	{
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetSucursal",
			
			success: function(response)
			{
				$('#sucursal_a').html(response).fadeIn();
			}
		}); 
	});
	
    // Función para guardar el usuario (aquí debes agregar la lógica de envío del formulario)
    function guardar() 
	{
		var loteria = $('#loteria').val();
		var cifras = $('#cifras').val();
		var suerte = $('#suerte').val();
		var valor = $('#valor').val();
		var premio = $('#premio').val();
		var sucursal = $('#sucursal').val();		

		// Validar que todos los campos estén llenos
		if (!loteria ||!cifras ||!suerte || !valor || !sucursal) {
			Swal.fire("Error","Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		
		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_suerte.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				loteria: loteria,
				cifras: cifras,
				suerte: suerte,
				valor: valor,
				premio: premio,
				sucursal: sucursal
			},
			beforeSend: function () {
				// Puedes deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="guardar()"]').prop('disabled', true);
			},
			success: function (response) {
				
				Swal.fire({
							title: 'Éxito',
							text: 'El premio fue guardado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});				
			},
			error: function (xhr, status, error) {
				
				Swal.fire("Error","Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				$('button[onclick="guardar()"]').prop('disabled', false); // Rehabilitar botón
			}
		});
	}
	
	//funcion para editar registro de usuario
	$(document).on('click', '.toggle-editar', function() 
	{
		var idsuerte_a = $(this).data('id');
		var suerte_a = $(this).data('suerte');
		var valor_a = $(this).data('valor');
		var premio_a = $(this).data('detalle');
		var sucursal_a = $(this).data('sucursal');		

		// Cargar los datos en un formulario de edición o modal
		$('#idsuerte_a').val(idsuerte_a);
		$('#suerte_a').val(suerte_a);
		$('#valor_a').val(valor_a);
		$('#premio_a').val(premio_a);
		$('#sucursal_a').val(sucursal_a);
		
		// Mostrar el modal o formulario
		$('#modalEditar').modal('show');
	});

	function actualizar() {
		// Obtener los valores de los campos
		var idsuerte_a = $('#idsuerte_a').val();
		var suerte_a = $('#suerte_a').val();
		var valor_a = $('#valor_a').val();
		var premio_a = $('#premio_a').val();
		var sucursal_a = $('#sucursal_a').val();		
		
		//alert(usuario_a);
		
		// Validar que todos los campos estén llenos
		if (!suerte_a || !valor_a || !sucursal_a) {
			Swal.fire("Error", "Por favor, complete todos los campos obligatorios.", "error");
			return;
		}

		// Enviar los datos por AJAX
		$.ajax({
			url: 'guardar_edicion_su.php', // Reemplaza con la URL correcta
			type: 'POST',
			data: {
				idsuerte_a: idsuerte_a,
				suerte_a: suerte_a,
				valor_a: valor_a,
				premio_a: premio_a,
				sucursal_a: sucursal_a
			},
			beforeSend: function () {
				// Deshabilitar el botón para evitar envíos múltiples
				$('button[onclick="actualizar()"]').prop('disabled', true);
			},
			success: function (response) {
				//alert(response);
				Swal.fire({
							title: 'Éxito',
							text: 'El premio fue actualizado correctamente.',
							icon: 'success',
							confirmButtonText: 'OK',
							timer: 2000
						}).then((result) => {
							if (result.isConfirmed || result.isDismissed) {
								location.reload(); // Recargar la página después de cerrar la alerta
							}
						});

			},
			error: function (xhr, status, error) {
				Swal.fire("Error", "Ocurrió un error al guardar los datos.", "error");
				console.error(error);
			},
			complete: function () {
				// Rehabilitar el botón después de completar la solicitud
				$('button[onclick="actualizar()"]').prop('disabled', false);
			}
		});
	}
	//funcio para cerra sesion
	function cerrar() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas cerrar sesión?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cerrar sesión',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../controllers/usuario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: new URLSearchParams({ boton: 'cerrar' })
                })
                .then(response => response.ok ? location.href = '../administracion.php' : Promise.reject(response.statusText))
                .catch(error => Swal.fire('Error', 'Hubo un error al cerrar sesión: ' + error, 'error'));
            }
        });
    }
</script>
</body>
</html>
