<?php
require __DIR__ . '/autoload.php';
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

// Nombre de la impresora compartida
$nombre_impresora = "POS";

try {
    $connector = new WindowsPrintConnector($nombre_impresora);
    $printer = new Printer($connector);
    $printer->setJustification(Printer::JUSTIFY_CENTER);

    // Ruta absoluta de la imagen
    $ruta_imagen = __DIR__ . "/logo.jpg";

    // Verificar si la imagen existe
    if (!file_exists($ruta_imagen)) {
        throw new Exception("Error: La imagen no se encuentra en " . $ruta_imagen);
    }

    // Cargar e imprimir la imagen
   // $logo = EscposImage::load($ruta_imagen, false);
    //$printer->graphics($logo); // Usa graphics() en lugar de bitImage()

    // Imprimir texto
    $printer->setTextSize(2, 2);
    $printer->text("Ticket con PHP\n");
    $printer->setTextSize(2, 1);
    $printer->feed();
    $printer->text("Hola mundo\n\nParzibyte.me\n\nNo olvides suscribirte");

    // Alimentar papel y cortar
    $printer->feed(5);
    $printer->cut();
    $printer->pulse();

    // Cerrar conexión con la impresora
    $printer->close();

} catch (Exception $e) {
    echo "Error de impresión: " . $e->getMessage();
}

?>
