<?php
// ticket_delete.php — Borrado lógico de un ticket pendiente
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Guayaquil');

require_once __DIR__ . '/conex.php';

if (!isset($_SESSION['idusuario'])) {
  echo json_encode(['success'=>false, 'message'=>'Sesión expirada']); exit;
}
$idusuario = (int)$_SESSION['idusuario'];

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) { echo json_encode(['success'=>false, 'message'=>'ID inválido']); exit; }

mysqli_set_charset($conn, 'utf8mb4');
if (function_exists('mysqli_report')) {
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
}

try {
  // Solo permite eliminar si el ticket pertenece al usuario, está pendiente (estado=1) y activo (condicion=1)
  $sql = "UPDATE tbr_ticket 
          SET condicion = 0
          WHERE idrifa = ? AND id_usuario = ? AND estado = 1 AND condicion = 1";
  $stmt = mysqli_prepare($conn, $sql);
  mysqli_stmt_bind_param($stmt, "ii", $id, $idusuario);
  mysqli_stmt_execute($stmt);

  if (mysqli_stmt_affected_rows($stmt) > 0) {
    echo json_encode(['success'=>true]);
  } else {
    echo json_encode(['success'=>false, 'message'=>'No autorizado o el ticket ya no está pendiente.']);
  }
  mysqli_stmt_close($stmt);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false, 'message'=>$e->getMessage()]);
}
