<?php
// usuarios_list.php — DataTable JSON
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/conex.php'; // Debe exponer $conn (mysqli)

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Sesión expirada.", "data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}
if (!($conn instanceof mysqli)) {
    echo json_encode(["error" => "Sin conexión a la base de datos.", "data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}
mysqli_set_charset($conn, 'utf8mb4');

$idusuario = (int)($_SESSION['idusuario'] ?? 0);
$rol       = (int)($_SESSION['rol']        ?? 0);

// Helper de escape seguro
function h(?string $v): string {
    return htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

// SQL por rol
if ($rol === 1) {
    $sql = "SELECT 
                u.idusuario, u.id_sucursal, u.usuario, s.sucursal,
                u.extra_cupo, u.cupo_activo,
                u.extra_cupo3, u.cupo_activo3,
                u.extra_cupo4, u.cupo_activo4,
                u.hora_inicio_a, u.hora_fin_a,
                u.activo, u.condicion, u.clave, u.id_rol,
                u.ip_permitida
            FROM tbr_usuario AS u
            LEFT JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
            WHERE u.condicion = 1";
    $stmt = $conn->prepare($sql);
} elseif ($rol === 3) {
    $sql = "SELECT 
                u.idusuario, u.id_sucursal, u.usuario, s.sucursal,
                u.extra_cupo, u.cupo_activo,
                u.extra_cupo3, u.cupo_activo3,
                u.extra_cupo4, u.cupo_activo4,
                u.hora_inicio_a, u.hora_fin_a,
                u.activo, u.condicion, u.clave, u.id_rol,
                u.ip_permitida
            FROM tbr_usuario AS u
            LEFT JOIN tbr_sucursal AS s ON s.idsucursal = u.id_sucursal
            WHERE u.condicion = 1
              AND u.id_administrador = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $idusuario);
} else {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

if (!$stmt || !$stmt->execute()) {
    echo json_encode(["error" => "Error de consulta.", "data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$res = $stmt->get_result();
$usuarios_data = [];

while ($row = $res->fetch_assoc()) {
    $id        = (int)$row['idusuario'];
    $admin_rol = (int)$row['id_rol'];

    // Forzar string en clave para atributos HTML (si en BD es hash/verás el hash)
    $claveAttr = h((string)($row['clave'] ?? ''));

    // Switch activo
    $boton_estado = '<label class="switch">
        <input type="checkbox" class="toggle-switch" data-id="'. $id .'" '. ((int)$row['activo'] === 1 ? 'checked' : '') .' data-estado="'. ((int)$row['activo'] === 1 ? 1 : 0) .'">
        <span class="slider round"></span>
    </label>';

    // Switch cupos
    $boton_cupo  = '<label class="switch"><input type="checkbox" class="toggle-switch2" data-id="'. $id .'" '. ((int)$row['cupo_activo']  === 1 ? 'checked' : '') .' data-estado="'. ((int)$row['cupo_activo']  === 1 ? 1 : 0) .'"><span class="slider round"></span></label>';
    $boton_cupo3 = '<label class="switch"><input type="checkbox" class="toggle-switch3" data-id="'. $id .'" '. ((int)$row['cupo_activo3'] === 1 ? 'checked' : '') .' data-estado="'. ((int)$row['cupo_activo3'] === 1 ? 1 : 0) .'"><span class="slider round"></span></label>';
    $boton_cupo4 = '<label class="switch"><input type="checkbox" class="toggle-switch4" data-id="'. $id .'" '. ((int)$row['cupo_activo4'] === 1 ? 'checked' : '') .' data-estado="'. ((int)$row['cupo_activo4'] === 1 ? 1 : 0) .'"><span class="slider round"></span></label>';

    // Botones acción
    $clear_ip = '<button class="btn btn-secondary btn-clear-ip" 
                    title="Borrar IP"
                    data-id="'. $id .'"
                    data-usuario="'. h($row['usuario']) .'"
                    data-ip="'. h($row['ip_permitida']) .'">
                    <i class="fa fa-eraser" aria-hidden="true"></i>
                 </button>';

    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="'. $id .'"
                    data-condicion="'. (int)$row['condicion'] .'">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                 </button>';

    // EDITAR (normal) con data-clave
    $editar = '<button class="btn btn-warning toggle-editar" 
                    data-id="'. $id .'"
                    data-usuario="'. h($row['usuario']) .'"
                    data-clave="'. $claveAttr .'"
                    data-sucursal="'. h((string)$row['id_sucursal']) .'"
                    data-cupo="'. h((string)$row['extra_cupo']) .'"
                    data-cupo3="'. h((string)$row['extra_cupo3']) .'"
                    data-cupo4="'. h((string)$row['extra_cupo4']) .'"
                    data-hora_inicio_a="'. h($row['hora_inicio_a']) .'"
                    data-hora_fin_a="'. h($row['hora_fin_a']) .'">
                    <i class="fa fa-pencil" aria-hidden="true"></i>
               </button>';

    // EDITAR (admin) con data-clave
    $editar_admin = '<button class="btn btn-warning toggle-editar_ad" 
                        data-id="'. $id .'"
                        data-usuario="'. h($row['usuario']) .'"
                        data-clave="'. $claveAttr .'">
                        <i class="fa fa-pencil" aria-hidden="true"></i>
                     </button>';

    if ($admin_rol === 1 || $admin_rol === 3) {
        // Para administradores, menos columnas
        $usuarios_data[] = [
            "usuario"           => h($row['usuario']),
            "sucursal"          => '',
            "cupo"              => '',
            "cupo3"             => '',
            "cupo4"             => '',
            "hora_i_anulacion"  => '',
            "hora_f_anulacion"  => '',
            "ip"                => h($row['ip_permitida']),
            "activo"            => $boton_estado,
            "accion"            => $clear_ip . ' ' . $editar_admin . ' ' . $eliminar
        ];
    } else {
        // Usuarios regulares
        $usuarios_data[] = [
            "usuario"           => h($row['usuario']),
            "sucursal"          => h($row['sucursal']),
            "cupo"              => h((string)$row['extra_cupo'])  . ' ' . $boton_cupo,
            "cupo3"             => h((string)$row['extra_cupo3']) . ' ' . $boton_cupo3,
            "cupo4"             => h((string)$row['extra_cupo4']) . ' ' . $boton_cupo4,
            "hora_i_anulacion"  => h($row['hora_inicio_a']),
            "hora_f_anulacion"  => h($row['hora_fin_a']),
            "ip"                => h($row['ip_permitida']),
            "activo"            => $boton_estado,
            "accion"            => $clear_ip . ' ' . $editar . ' ' . $eliminar
        ];
    }
}

echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
