<?php
session_start();

// Verifica si las variables de sesión están definidas
if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
    header('Location: index.php'); // Redirige al login si no hay sesión activa
    exit();
}

$idusuario = htmlspecialchars($_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal = htmlspecialchars($_SESSION['sucursal']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Panel de administración para gestionar usuarios y configuraciones.">
    <meta name="keywords" content="panel, administración, usuarios, reportes, gestión">
    <title>Sistema de Gestión</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <!-- Carga de bibliotecas necesarias -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.7/dayjs.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.7/locale/es.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <style>
		 /* Aplicar un tamaño de fuente y altura mínima global para el formulario */
		.form-control, .selectpicker, .btn {
			font-size: 2em;
			min-height: 2em;
		}
        body {
            background-color: #f4f6f9;
        }
        .navbar {
            margin-bottom: 20px;
        }
        .content {
            padding: 1rem;
        }
        .sidebar {
			width: 250px;
			background: #343a40;
			padding: 20px;
			height: 100vh;
			position: fixed;
			left: 0;
			top: 0;
			display: flex;
			flex-direction: column;
			align-items: center;
		}

		.sidebar h4 {
			font-size: 1.2rem;
		}

		.sidebar a {
			color: white;
			text-decoration: none;
			padding: 15px;
			width: 100%;
			display: flex;
			flex-direction: column;
			align-items: center;
			transition: background 0.3s, transform 0.2s;
		}

		.sidebar a i {
			margin-bottom: 8px;
		}

		.sidebar a:hover {
			background: rgba(255, 255, 255, 0.1);
			transform: scale(1.05);
			border-radius: 8px;
		}

		.sidebar .active {
			font-weight: bold;
			color: #17a2b8;
		}
        .sidebar.show {
            transform: translateX(0);
        }
        .sidebar a {
            color: white;
            padding: 10px 15px;
            text-decoration: none;
            display: block;
        }
        /*.sidebar a.active {
            background-color: #17a2b8;
            font-weight: bold;
        }*/
        .sidebar a:hover {
            background-color: #495057;
        }
        .main-content {
            margin-left: 0;
            transition: margin-left 0.3s;
        }
        @media (min-width: 769px) {
            .sidebar {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 250px;
            }
        }
        .loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 20px;
            font-weight: bold;
            z-index: 2000;
        }
        .loader::before {
            content: '';
            width: 40px;
            height: 40px;
            border: 5px solid #fff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
		.selectpicker {
			font-size: 1.25em; /* Ajusta el tamaño de la fuente */
			
			heigh
		height: 2.5em; /* Ajusta la altura */
			padding: 0.375rem 0.75rem; /* Asegura que el padding sea el mismo que otros campos */
		}
		/* Aumentar tamaño de texto en todos los campos */
		.form-control, .selectpicker, .btn {
			font-size: 3em;  /* Aumenta el tamaño de la fuente */
			min-height: 3em; /* Ajusta la altura si es necesario */
		}

		/* Aumentar tamaño de texto en el selector de loterías */
		.selectpicker {
			font-size: 1.5em;  /* Aumenta el tamaño de la fuente solo en el select */
			height: 1.5em; /* Ajusta la altura */
			padding: 0.375rem 0.75rem; /* Asegura que el padding sea consistente */
		}
		/* Aumentar tamaño de texto en los campos de entrada */
		.form-control, .selectpicker, .btn {
			font-size: 1.5em;  /* Aumenta el tamaño de la fuente */
			min-height: 2.5em; /* Ajusta la altura */
		}

		/* Aumentar tamaño de texto en los campos input específicos */
		input.form-control {
			font-size: 1.5em;  /* Aumenta el tamaño del texto en los inputs */
			height: 3em;       /* Ajusta la altura para que coincida con el tamaño de la fuente */
		}
		/* Aumentar el tamaño del calendario */
		input[type="date"]::-webkit-calendar-picker-indicator {
			width: 60px;  /* Ajusta el ancho */
			height: 60px; /* Ajusta la altura */
			font-size: 4em; /* Cambia el tamaño de la fuente */
		}
		/* Cambiar el tamaño de los números en el calendario */
		.ui-datepicker-calendar td a {
			font-size: 30px;  /* Ajusta el tamaño de los números */
			padding: 10px;    /* Ajusta el espacio alrededor de los números */
		}

		.ui-datepicker {
			font-size: 18px;  /* Ajusta el tamaño de la fuente en el calendario */
		}

		.ui-datepicker-header {
			font-size: 22px;  /* Ajusta el tamaño de la cabecera (mes, año) */
		}

    </style>
</head>
<body>

    <!-- Sidebar (Menú lateral) -->
   <!-- Sidebar (Menú lateral) -->
	<nav class="sidebar" id="sidebar">
		<h4 class="text-center text-white mb-3">
			<a href="dashboard.php" aria-label="Ir al Dashboard">
				<i class="fa fa-tachometer-alt" aria-hidden="true"></i> Dashboard
			</a>
		</h4>
		<ul class="nav flex-column text-center">
			<li class="nav-item">
				<a href="#" class="nav-link active">
					<i class="fas fa-file-invoice-dollar fa-3x" aria-hidden="true"></i>
					<div class="text-uppercase">Ventas</div>
				</a>
			</li>
			<li class="nav-item">
				<a href="historial.php" class="nav-link">
					<i class="fa fa-history fa-3x" aria-hidden="true"></i>
					<div class="text-uppercase">Historial</div>
				</a>
			</li>
			<li class="nav-item">
				<a href="javascript:void(0)" class="nav-link" onclick="cerrar();" aria-label="Cerrar sesión">
					<i class="fas fa-sign-out-alt fa-3x" aria-hidden="true"></i>
					<div class="text-uppercase">Cerrar Sesión</div>
				</a>
			</li>
		</ul>
	</nav>
    
    <!-- Contenido Principal -->
    <div class="main-content" id="mainContent">
        <nav class="navbar navbar-expand-lg navbar-light bg-light">
            <div class="container-fluid">
                <button class="navbar-toggler" type="button" aria-label="Toggle navigation" onclick="toggleSidebar()">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="navbar-brand" href="#"><i class="fas fa-tachometer-alt"></i></a>
                <div class="collapse navbar-collapse">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link active" href="#"><i class="fa fa-store"></i> <?php echo " ".$sucursal; ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="#"><i class="fa fa-user-secret"></i> <?php echo " ".$usuario; ?></a>                        
                        </li>
                        <li class="nav-item">
                            <a class="nav-link"><i class="fa fa-calendar-check"></i> <span id="fechaActual"></span></a>
                        </li>
                        <li class="nav-item d-none d-md-block">
                            <a class="nav-link"><em class="fas fa-clock text-mac"></em>&nbsp;<span id="horaActual"></span></a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>        
       
        <section class="section-container">
			<!-- Page content-->
			<div class="content-wrapper">
				<div class="col-sm-10 col-md-10 col-lg-10 float-left">
                    <h3><a>Historial de Ventas <i class="fas fa-file-invoice-dollar fa-1x text-primary"></i></a></h3>
                </div>
				<!-- Zero Configuration-->
				<!-- START card-->
				<div class="card card-default">
					<div class="card-body">
						<button class="btn btn-sm btn-success float-right mb-2" onclick="exportarDataExcel()" id="btnExport">
							<i	class="fas fa-file-excel"></i> Exportar a Excel
						</button>
						<div class="table-responsive rounded">
							<table class="table table-sm table-striped table-hover" cellpadding="0" cellspacing="0"	id="tableHistorial">
								<thead>
									<tr class="text-center">
										<th> ID&nbsp;<i class="fas fa-sort-numeric-down"></i> </th>
										<th> Loteria&nbsp;<i class="fas fa-comments"></i> </th>
										<th> Número&nbsp;<i class="fas fa-list-ol"></i> </th>
										<th> Fecha Realizado&nbsp;<i class="fas fa-calendar"></i> </th>
										<th> Fecha Juega&nbsp;<i class="fas fa-calendar-check"></i> </th>
										<th> Valor&nbsp;<i class="fas fa-dollar-sign"></i> </th>
										<th> Tope 1&nbsp;<i class="fas fa-funnel-dollar"></i> </th>
										<th> Tope 2&nbsp;<i class="fas fa-comments-dollar"></i> </th>
										<th> Negocio&nbsp;<i class="fas fa-calendar-check"></i> </th>
										<th> Usuario&nbsp;<i class="fas fa-user"></i> </th>
										<th> Porcentaje&nbsp;<i class="fas fa-user"></i> </th>
										<th> Valor a pagar&nbsp;<i class="fas fa-dollar-sign"></i> </th>
									</tr>
								</thead>
								<tfoot class="bg-success-light">
									<tr>
										<th>TOTALES</th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
										<th></th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</div>
			</div>
		</section>

		<script> var dataGet = JSON.parse('{"tipo":"hoy"}');</script>		<!-- Page footer-->
		<footer class="footer-container text-right">
			<span class="mr-2">Derechos Reservados -</span>
			<span class="mr-2">&copy;</span>
			<span>2025</span>
		</footer>
	</div>
	<div id="sweet_alert"></div>
    </div>

    <!-- Cargar scripts al final -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/bootstrap-select.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/i18n/defaults-es_ES.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        function cerrar() {
            Swal.fire({
                title: '¿Estás seguro?',
                text: '¿Deseas cerrar sesión?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sí, cerrar sesión',
                cancelButtonText: 'Cancelar',
                customClass: {
                    confirmButton: 'swal2-confirm',
                    cancelButton: 'swal2-cancel',
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    const loader = document.createElement('div');
                    loader.className = 'loader';
                    loader.textContent = 'Cerrando sesión...';
                    document.body.appendChild(loader);

                    fetch('../../controllers/usuario.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: new URLSearchParams({ boton: 'cerrar' }),
                    })
                    .then((response) => {
                        if (!response.ok) throw new Error('Error en la solicitud');
                        return response.text();
                    })
                    .then(() => location.href = '../index.php')
                    .catch((error) => Swal.fire('Error', error.message, 'error'))
                    .finally(() => loader.remove());
                }
            });
        }

        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }

        $(document).ready(function () {
            dayjs.locale('es');
            $('#fechaActual').text(dayjs().format('dddd, DD MMMM YYYY'));
            setInterval(function () {
                $('#horaActual').text(dayjs().format('h:mm A'));
            }, 60000); // Actualización de hora cada minuto
        });
    </script>
</body>
</html>
