<?php
require_once('../models/usuario.php');

// Validar si existe el parámetro 'boton'
if (!isset($_POST['boton'])) {
    echo json_encode(['success' => false, 'message' => 'Solicitud no válida.']);
    exit;
}

$boton = $_POST['boton'];

// 🔒 FUNCION PARA CERRAR SESIÓN
if ($boton === 'cerrar') {
    session_start();
    session_destroy();
    echo json_encode(['success' => true, 'message' => 'Sesión cerrada correctamente.']);
    exit;
}

// 🔐 FUNCIÓN PARA INICIAR SESIÓN
if ($boton === 'ingresar') {
    $usuario = isset($_POST['usuario']) ? trim($_POST['usuario']) : '';
    $pass = isset($_POST['pass']) ? trim($_POST['pass']) : '';

    if ($usuario === '' || $pass === '') {
        echo json_encode(['success' => false, 'message' => 'Usuario y contraseña son requeridos.']);
        exit;
    }

    $ins = new insertar();
    $array = $ins->identificar($usuario, $pass);

    if (!is_array($array) || count($array) < 2 || $array[0] == 0) {
        echo json_encode(['success' => false, 'message' => 'Credenciales incorrectas.']);
    } else {
        session_start();
        $_SESSION['ingreso'] = 'YES';
        $_SESSION['idusuario'] = $array[0];
        $_SESSION['usuario'] = $array[1];
        // Puedes agregar más variables de sesión si lo necesitas

        echo json_encode(['success' => true]);
    }

    exit;
}

// ❌ Cualquier otro valor de 'boton'
echo json_encode(['success' => false, 'message' => 'Acción no reconocida.']);
exit;
