<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>URBANVIEW</title>
  <link rel="shortcut icon" href="resources/img/logour.ico"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet" />

  <style>
    body {
      background-color: #000;
      color: #fff;
      font-size: 1rem;
      padding-top: 70px;
      padding-bottom: 40px;
      min-height: 100vh;
      position: relative;
    }

    body::before {
      content: "";
      position: fixed;
      top: 0; left: 0; right: 0; bottom: 0;
      background: url('resources/img/ruban.png') no-repeat center;
      background-size: 1050px 1050px;
      opacity: 1;
      pointer-events: none;
      z-index: 0;
    }

    .container {
      z-index: 2;
      position: relative;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 1rem;
    }

    #login-box {
      width: 100%;
      max-width: 420px;
      background-color: rgba(39, 37, 38, 0.75);
      border-radius: 18px;
      padding: 2rem 1.5rem;
      box-shadow: 0 0 20px rgba(252, 250, 252, 0.82);
      opacity: 0;
      transform: translateY(-20px);
      transition: all 0.6s ease;
    }

    body.loaded #login-box {
      opacity: 1;
      transform: translateY(0);
    }

    .form-control {
      background-color: #2c2c2c;
      border: 1px solid #444;
      color: #fff;
      padding: 0.75rem;
    }

    .form-control::placeholder {
      color: #aaa;
    }

    .input-group-text {
      background-color: rgb(44, 39, 39);
      color: #fff;
      border: 1px solid #444;
    }

    .btn-primary {
      border: none;
      font-size: 1.1rem;
      padding: 0.75rem;
    }

    .btn-primary:hover {
      background-color: rgba(248, 248, 252, 0.43);
    }

    .alert {
      display: none;
    }

    .alert.show {
      display: block !important;
      animation: fadeIn 0.4s ease-in-out;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: scale(0.98); }
      to { opacity: 1; transform: scale(1); }
    }

    .toggle-password {
      cursor: pointer;
    }

    footer {
      text-align: center;
      color: #aaa;
      font-size: 0.95rem;
      margin-top: 1.5rem;
    }

    @media (max-width: 576px) {
      body {
        font-size: 0.95rem;
        padding-top: 40px;
      }

      #login-box {
        padding: 1.5rem 1rem;
      }

      .btn-primary {
        font-size: 1rem;
      }
    }
  </style>
</head>

<body>
  <div class="container">
    <div id="login-box" class="text-center">
      <p class="text-white fs-5 fw-semibold mb-3">Inicia sesión para continuar...</p>

      <div class="alert alert-danger" id="error-msg" role="alert">
        <i class="fas fa-exclamation-circle me-1"></i>
        <span id="error-text">Usuario o contraseña incorrectos.</span>
      </div>

      <form id="login-form" class="form-signin" autocomplete="off">
        <div class="mb-3 input-group">
          <span class="input-group-text"><i class="fas fa-user"></i></span>
          <input type="text" id="usuario" class="form-control" placeholder="Usuario" required />
        </div>

        <div class="mb-3 input-group">
          <span class="input-group-text"><i class="fas fa-lock"></i></span>
          <input type="password" id="pass" class="form-control" placeholder="Contraseña" required />
          <span class="input-group-text toggle-password"><i class="fas fa-eye-slash"></i></span>
        </div>

        <div class="form-check text-start mb-3">
          <input class="form-check-input" type="checkbox" id="rememberMe">
          <label class="form-check-label" for="rememberMe">Recordarme</label>
        </div>

        <button class="btn btn-primary w-100 btn-login" type="submit">
          <i class="fas fa-sign-in-alt me-1"></i> Iniciar sesión
        </button>
      </form>

      <footer>
        <small>&copy; 2025 Sistema Digital Urbanview</small>
      </footer>
    </div>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    let isSubmitting = false;

    $(window).on('load', function () {
      $('body').addClass('loaded');
    });

    $('#login-form').on('submit', function (e) {
      e.preventDefault();
      confirmar();
    });

    function mostrarError(mensaje) {
      const $errorBox = $('#error-msg');
      $('#error-text').text(mensaje);
      $errorBox.addClass('show');
      setTimeout(() => $errorBox.removeClass('show'), 4000);
    }

    function confirmar() {
      if (isSubmitting) return;

      const usuario = $('#usuario').val().trim();
      const pass = $('#pass').val().trim();
      const $btn = $('.btn-login');

      if (!usuario || !pass) {
        mostrarError('Por favor, completa todos los campos.');
        return;
      }

      isSubmitting = true;

      $.ajax({
        url: 'controllers/usuario.php',
        type: 'POST',
        data: { usuario, pass, boton: 'ingresar' },
        beforeSend: function () {
          $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i> Iniciando...');
        }
      }).done(function (resp) {
        try {
          const data = JSON.parse(resp);
          if (data.success) {
            window.location.href = 'views/pages/';
          } else {
            mostrarError(data.message || 'Usuario o contraseña incorrectos.');
          }
        } catch (e) {
          mostrarError('Respuesta inválida del servidor.');
        }
      }).fail(function () {
        mostrarError('Error de red o del servidor.');
      }).always(function () {
        isSubmitting = false;
        $btn.prop('disabled', false).html('<i class="fas fa-sign-in-alt me-1"></i> Iniciar sesión');
      });
    }

    $('.toggle-password').on('click', function () {
      const input = $('#pass');
      const icon = $(this).find('i');
      const isPassword = input.attr('type') === 'password';
      input.attr('type', isPassword ? 'text' : 'password');
      icon.toggleClass('fa-eye fa-eye-slash');
    });
  </script>
</body>
</html>
