let tabla;
let marcasCache = [];
let zonasCache = [];
let cantonesCache = {};
let videoCache = [];

function cargarMarcas() {
  if (marcasCache.length > 0) {
    return $.Deferred().resolve(marcasCache).promise();
  }
  return $.getJSON('get_marcas.php', function (data) {
    marcasCache = data;
  });
}

function cargarZonas() {
  if (zonasCache.length > 0) {
    return $.Deferred().resolve(zonasCache).promise();
  }
  return $.getJSON('get_zonas.php', function (data) {
    zonasCache = data;
  });
}

function cargarCantones(idZona) {
  if (cantonesCache[idZona]) {
    return $.Deferred().resolve(cantonesCache[idZona]).promise();
  }
  return $.getJSON('get_cantones.php', { id_zona: idZona }, function (data) {
    cantonesCache[idZona] = data;
  });
}

function cargarVideo() {
  if (videoCache.length > 0) {
    return $.Deferred().resolve(videoCache).promise();
  }
  return $.getJSON('get_videos.php', function (data) {
    videoCache = data;
  });
}

function convertirFechaISO(fecha) {
  if (!fecha) return '';
  if (fecha.includes('/')) {
    const parts = fecha.split('/');
    if (parts.length === 3) {
      return `${parts[2]}-${parts[1].padStart(2, '0')}-${parts[0].padStart(2, '0')}`;
    }
  }
  return fecha;
}

function obtenerValorCelda(fila, index) {
  const celda = fila.find(`td:eq(${index})`);
  const input = celda.find('input');
  if (input.length > 0) return input.val();

  const select = celda.find('select');
  if (select.length > 0) {
    const selectedOption = select.find('option:selected');
    return selectedOption.val();
  }

  return celda.text().trim();
}

function actualizarCantonPorZona(fila, idZonaSeleccionada, cantonActual = '') {
  cargarCantones(idZonaSeleccionada).done(function (cantones) {
    const cantonCell = fila.find('td').eq(2);
    let cantonSelect = '<select class="form-select form-select-sm canton-select">';
    cantones.forEach(canton => {
      const selected = canton.canton === cantonActual ? 'selected' : '';
      cantonSelect += `<option value="${canton.canton}" data-id="${canton.id}" ${selected}>${canton.canton}</option>`;
    });
    cantonSelect += '</select>';
    cantonCell.html(cantonSelect);
    cantonCell.removeClass('editable');
    cantonCell.find('select').focus();
  });
}

$(document).ready(function () {
  tabla = $('#publicidad').DataTable({
    ordering: false,
    ajax: {
      url: 'funcion_publicidad.php',
      dataSrc: 'data'
    },
    columns: [
      { data: 'marca' },
      { data: 'zona' },
      { data: 'canton' },
      { data: 'video' },
      { data: 'fechai' },
      { data: 'fechaf' },
      {
        data: 'activo',
        render: function (data) {
          return `
            <label class="switch">
              <input type="checkbox" class="activar" ${data == 1 ? 'checked' : ''}>
              <span class="slider"></span>
            </label>
          `;
        }
      },
      {
        data: null,
        orderable: false,
        render: function (data, type, row) {
          const fechaFin = row.fechaf;
          const hoy = new Date();
          const partes = fechaFin.split('-');
          const fechaFinal = new Date(partes[0], partes[1] - 1, partes[2]);

          hoy.setHours(0, 0, 0, 0);
          fechaFinal.setHours(0, 0, 0, 0);

          const diffTime = fechaFinal - hoy;
          const diffDias = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

          let clase = 'btn-primary';
          let texto = '';
          let icono = 'fas fa-dollar-sign';
          let textoBoton = '';

          if (diffDias < 0) {
            texto = `Venció hace ${Math.abs(diffDias)} día${Math.abs(diffDias) === 1 ? '' : 's'}`;
            clase = 'btn-secondary';
          } else if (diffDias <= 3) {
            texto = `Faltan ${diffDias} día${diffDias === 1 ? '' : 's'} para la fecha de corte`;
            clase = 'btn-danger';
          } else if (diffDias <= 10) {
            texto = `Faltan ${diffDias} días para la fecha de corte`;
            clase = 'btn-warning';
          } else {
            texto = `Faltan ${diffDias} días para la fecha de corte`;
          }

          if (row.pagado == 1) {
            clase = 'btn-success';
            texto = 'Pago ya registrado';
            icono = 'fas fa-check-circle';
            textoBoton = 'Pagado';
          }

          return `
            <button class="btn btn-sm ${clase} pagar" title="${texto}">
              <i class="${icono}"></i> ${textoBoton}
            </button>
            <button class="btn btn-sm btn-success guardar" title="Guardar"><i class="fas fa-save"></i></button>
            <button class="btn btn-sm btn-danger eliminar" title="Eliminar"><i class="fas fa-trash-alt"></i></button>
          `;
        }
      }
    ],
    columnDefs: [
      { targets: [0, 1, 2, 3, 4, 5], className: 'editable' }
    ]
  });
});
