<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
require_once __DIR__ . '/conex.php';

if (!isset($_SESSION['idusuario'])) {
  echo json_encode(['success'=>false,'message'=>'Sesión expirada.'], JSON_UNESCAPED_UNICODE); exit;
}
if (!isset($conex) || !$conex instanceof mysqli) {
  echo json_encode(['success'=>false,'message'=>'Sin conexión a BD.'], JSON_UNESCAPED_UNICODE); exit;
}
mysqli_set_charset($conex, 'utf8mb4');

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$activa = isset($_POST['activa']) ? (int)$_POST['activa'] : -1;
if ($id <= 0 || ($activa !== 0 && $activa !== 1)) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos.'], JSON_UNESCAPED_UNICODE); exit;
}

$stmt = mysqli_prepare($conex, "UPDATE tb_video SET activo = ? WHERE id = ? AND condicion = 1");
if (!$stmt) {
  echo json_encode(['success'=>false,'message'=>'Error al preparar la consulta.'], JSON_UNESCAPED_UNICODE); exit;
}
mysqli_stmt_bind_param($stmt, 'ii', $activa, $id);
$ok = mysqli_stmt_execute($stmt);
mysqli_stmt_close($stmt);

echo json_encode(['success'=>$ok ? true : false, 'message'=>$ok ? 'Estado actualizado.' : 'No se pudo actualizar.'], JSON_UNESCAPED_UNICODE);
