<?php
session_start();
include("conex.php");
header('Content-Type: application/json');

// Si es para app móvil, puedes dejar desactivado el control de sesión:
/*
if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["error" => "Sesión expirada."]);
    exit;
}
*/

// Obtener parámetro 'placa' desde GET o POST
$placa = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $placa = trim($_POST['placa'] ?? '');
} else {
    $placa = trim($_GET['placa'] ?? '');
}
$placa = mysqli_real_escape_string($conex, $placa);

// Consulta base
$sql = "
    SELECT v.placa, v.nombre, v.telefono, v.cooperativa, v.id_table, 
           v.id_zona, z.zona, v.id_canton, c.canton, t.modelo, t.serie, t.estado, v.condicion      
    FROM tb_vehiculo AS v
    LEFT JOIN tb_table AS t ON t.id = v.id_table
    INNER JOIN tb_zona AS z ON z.id = v.id_zona
    INNER JOIN tb_canton AS c ON c.id = v.id_canton
    WHERE v.condicion = 1
";

// Agregar filtro por placa si se proporciona
if ($placa !== '') {
    $sql .= " AND v.placa LIKE '%$placa%'";
}

$resultado = mysqli_query($conex, $sql);

if (!$resultado) {
    echo json_encode(["error" => "Error en la consulta: " . mysqli_error($conex)]);
    exit;
}

$vehiculos = [];

while ($row = mysqli_fetch_assoc($resultado)) {
    $vehiculos[] = [        
        "placa"        => $row['placa'],
        "nombre"       => $row['nombre'],
        "telefono"     => $row['telefono'],
        "cooperativa"  => $row['cooperativa'],        
        "zona"         => $row['zona'],
        "canton"       => $row['canton'],
        "modelo"       => $row['modelo'],
        "serie"        => $row['serie'],
        "estado_table" => $row['estado']
    ];
}

// Devolver los datos como JSON
echo json_encode(["data" => $vehiculos], JSON_UNESCAPED_UNICODE);
?>
