<?php
session_start();
if (!isset($_SESSION['usuario']) || empty($_SESSION['usuario'])) {
    header('Location: ../../index.php');
    exit();
}
$usuario = $_SESSION['usuario'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>URBANVIEW</title>
<link rel="shortcut icon" href="../../resources/img/logour.ico" />
<meta name="viewport" content="width=device-width, initial-scale=1" />

<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- FontAwesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet" />
<!-- DataTables CSS -->
<link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

<style>
html, body {
  height: 100%;
  margin: 0;
  overflow: hidden;
  font-family: Arial, Helvetica, sans-serif;
}
body {
  display: flex;
  flex-direction: column;
}
.topbar {
  height: 60px;
  background: #343a40;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 20px;
  position: fixed;
  top: 0; left: 0; right: 0;
  z-index: 1000;
}
.wrapper {
  display: flex;
  flex-grow: 1;
  margin-top: 60px;
  height: calc(100vh - 60px);
  overflow: hidden;
}
.sidebar {
  width: 250px;
  background: #343a40;
  padding: 20px;
  overflow-y: auto;
  flex-shrink: 0;
  transition: width 0.3s ease;
}
.sidebar.collapsed {
  width: 80px;
}
.sidebar a {
  color: #fff;
  text-decoration: none;
  padding: 12px;
  display: flex;
  align-items: center;
}
.main-content {
  flex-grow: 1;
  height: 100%;
  display: flex;
  flex-direction: column;
  margin-left: 250px;
  padding: 20px;
  transition: margin-left 0.3s ease;
  overflow-y: auto;
}
.sidebar.collapsed ~ .main-content {
  margin-left: 80px;
}
.info {
  display: flex;
  align-items: center;
  gap: 1rem;
}
@media (max-width: 768px) {
  .sidebar {
    position: fixed;
    top: 60px;
    left: 0;
    height: calc(100% - 60px);
    z-index: 999;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    width: 250px;
  }
  .sidebar.show {
    transform: translateX(0);
  }
  .main-content {
    margin-left: 0 !important;
  }
  .wrapper {
    flex-direction: column;
  }
}
</style>
<style>
	.switch-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
}

.switch-custom {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}

.switch-custom input {
  opacity: 0;
  width: 0;
  height: 0;
}

.slider-custom {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 34px;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 10px;
  font-size: 16px;
  color: white;
}

.slider-custom .icon-on,
.slider-custom .icon-off {
  opacity: 0;
  transition: opacity 0.3s ease;
}

input:checked + .slider-custom {
  background-color: #28a745; /* verde */
}

input:checked + .slider-custom .icon-on {
  opacity: 1;
}

input:checked + .slider-custom .icon-off {
  opacity: 0;
}

input:not(:checked) + .slider-custom .icon-off {
  opacity: 1;
}

input:not(:checked) + .slider-custom .icon-on {
  opacity: 0;
}


</style>

</head>
<body>
<header class="topbar">
  <button class="btn btn-dark" onclick="toggleSidebar()" aria-label="Toggle sidebar">
    <i class="fas fa-bars"></i>
  </button>
  <span>URBANVIEW</span>
  <div class="info">
    <span><?=htmlspecialchars($usuario, ENT_QUOTES, 'UTF-8');?></span>
    <span id="fechaActual"></span>
    <span id="horaActual"></span>
    <button class="btn btn-sm btn-danger" onclick="cerrarSesion(event)">
      <i class="fas fa-sign-out-alt"></i>
    </button>
  </div>
</header>

<div class="wrapper">
  <nav class="sidebar"><?php include "menu.php"; ?></nav>
  <div class="main-content">
    <div class="row mb-3">
      <div class="col-md-3">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#agregarCantonesModal">
          <i class="fas fa-plus"></i> Agregar Cantón
        </button>
      </div>
    </div>

    <div class="table-responsive">
      <table id="cantones" class="table table-striped table-bordered" style="width:100%">
		  <thead class="table-dark">
			<tr>
			  <th>ZONA</th>
			  <th>CANTÓN</th>
			  <th>ACTIVO</th>
			  <th>ACCIÓN</th>
			</tr>
		  </thead>
		  <tbody>
			<!-- PHP o AJAX aquí para cargar los cantones -->
		  </tbody>
		</table>
    </div>
  </div>
</div>

<!-- Modal Agregar Cantón -->
<div class="modal fade" id="agregarCantonesModal" tabindex="-1" aria-labelledby="agregarCantonesModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formAgregarCanton" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="agregarCantonesModalLabel">Agregar Nuevo Cantón</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="zona" class="form-label">Nombre de la Zona</label>
          <select name="zona" id="zona" class="form-control" placeholder="Selecciona la Zona..." required></select> 
        </div>
		
		<div class="mb-3">
          <label for="canton" class="form-label">Nombre de Cantón</label>
          <input type="text" class="form-control" id="canton" name="canton" required>
        </div>			
        
      </div>
      <div class="modal-footer">
        <button type="button" onclick="guardar()" class="btn btn-primary">Agregar</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>

<!-- Modal Editar Zona -->
<div class="modal fade" id="editarCantonModal" tabindex="-1" aria-labelledby="editarCantonModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formEditarCanton" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editarCantonModalLabel">Editar Cantón</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <!-- Solo uno de estos inputs es necesario -->
        <input type="hidden" id="edit_id_canton" name="id">

        <div class="mb-3">
          <label for="edit_id_zona" class="form-label">Nombre de Zona</label>
          <select name="edit_id_zona" id="edit_id_zona" class="form-control" required>
            <!-- Opciones cargadas dinámicamente -->
          </select> 
        </div>

        <div class="mb-3">
          <label for="edit_canton" class="form-label">Nombre de Cantón</label>
          <input type="text" class="form-control" id="edit_canton" name="edit_canton" required>
        </div>
      </div>
	  
      <div class="modal-footer">
        <button type="button" id="btnGuardarCanton" class="btn btn-primary">Guardar Cambios</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
      </div>
    </form>
  </div>
</div>



<!-- JS: jQuery, Bootstrap, DataTables, SweetAlert -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="../../resources/js/menu_canton.js"></script>
<script>
let sidebar = document.querySelector('.sidebar');

function actualizarHora() {
  const ahora = new Date();
  const opF = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  const opH = { hour: '2-digit', minute: '2-digit', second: '2-digit' };
  document.getElementById('fechaActual').textContent = ahora.toLocaleDateString('es-ES', opF);
  document.getElementById('horaActual').textContent = ahora.toLocaleTimeString('es-ES', opH);
}
setInterval(actualizarHora, 1000);
actualizarHora();

function toggleSidebar() {
  if (window.innerWidth <= 768) {
    sidebar.classList.toggle('show');
  } else {
    sidebar.classList.toggle('collapsed');
  }
}
document.addEventListener('click', function(e) {
  const toggleBtn = e.target.closest('button[onclick="toggleSidebar()"]');
  if (window.innerWidth <= 768 && !sidebar.contains(e.target) && !toggleBtn) {
    sidebar.classList.remove('show');
  }
});
function cerrarSesion(e) {
  Swal.fire({
    title: '¿Cerrar sesión?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí',
    cancelButtonText: 'No'
  }).then(res => {
    if (res.isConfirmed) {
      fetch('../../controllers/usuario.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({boton: 'cerrar'})
      }).then(response => {
        if (response.ok) {
          window.location.href = '../../index.php';
        } else {
          throw new Error('Error al cerrar sesión');
        }
      }).catch(err => {
        Swal.fire('Error', err.message, 'error');
      });
    }
  });
}

$(document).on('change', '.toggle-switch', function() {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let nuevoEstado = checkbox.is(':checked') ? 1 : 0;

    $.ajax({
        url: 'actualizar_estado_canton.php', // Archivo PHP que procesa la actualización
        method: 'POST',
        data: { id: id, activa: nuevoEstado },
        success: function(response) {
            // Puedes procesar la respuesta si quieres mostrar mensajes
            checkbox.data('estado', nuevoEstado); // Actualiza el atributo data-estado
        },
        error: function() {
            alert('Error al actualizar el estado.');
            // Opcional: revertir el checkbox si falla
            checkbox.prop('checked', !nuevoEstado);
        }
    });
});


</script>
<script>
//Funcion zona
	$(document).ready(function() {
		$.ajax({
			type: "POST",
			url: "datos.php?Accion=GetZona",			
			success: function(response)
			{
				$('#zona').html(response).fadeIn();
			}
		}); 
	});
</script>
<script>
// Cargar zonas dinámicamente al abrir el modal
$(document).ready(function() {
  $.ajax({
    type: "POST",
    url: "datos.php?Accion=GetZona2",
    success: function(response) {
      $('#edit_id_zona').html(response).fadeIn();
    },
    error: function() {
      console.error("Error al cargar zonas.");
    }
  });
});
</script>

<script>
function guardar() {
  const zona = $('#zona').val().trim();
  const canton = $('#canton').val().trim();

  if (!zona || !canton) {
    Swal.fire({
      icon: 'warning',
      title: 'Campos obligatorios',
      text: 'Por favor ingresa el nombre de la zona y el cantón.',
    });
    return;
  }

  const formData = new FormData();
  formData.append('zona', zona);
  formData.append('canton', canton);

  fetch('guardar_canton.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Cantón agregado',
        text: 'El cantón se ha guardado correctamente.',
        timer: 2000,
        showConfirmButton: false
      });
      $('#agregarCantonesModalModal').modal('hide');
      $('#formAgregarCanton')[0].reset();
      setTimeout(() => location.reload(), 2000);
    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar el cantón.'
      });
    }
  })
  .catch(error => {
    console.error(error);
    Swal.fire({
      icon: 'error',
      title: 'Error del servidor',
      text: 'No se pudo guardar el cantón. Inténtalo de nuevo más tarde.'
    });
  });
}

</script>

<script>
  $(document).on('click', '.toggle-editar', function () {
    let idCanton = $(this).data('id');            // ID del cantón (para el campo oculto)
    let idZona = $(this).data('zona');            // ID de la zona asociada
    let nombreCanton = $(this).data('canton');    // Nombre del cantón

    // Llenar campos del formulario
    $('#edit_id_canton').val(idCanton);          // campo oculto
    $('#edit_id_zona').val(idZona);              // select de zonas
    $('#edit_canton').val(nombreCanton);         // input de texto

    // Mostrar modal
    $('#editarCantonModal').modal('show');
  });
</script>

<script>
function actualizarCanton() {
  const id = $('#edit_id_canton').val();
  const idZona = $('#edit_id_zona').val();
  const nombreCanton = $('#edit_canton').val().trim();

  if (!idZona || !nombreCanton) {
    Swal.fire('Campos requeridos', 'Debes completar todos los campos.', 'warning');
    return;
  }

  $.post('editar_canton.php', { id, id_zona: idZona, canton: nombreCanton }, function (data) {
    if (data.success) {
      Swal.fire({
        icon: 'success',
        title: 'Cantón actualizado',
        text: 'El cantón se ha guardado correctamente.',
        timer: 2000,
        showConfirmButton: false
      });

      $('#editarCantonModal').modal('hide');
		
      // Actualiza la fila directamente sin recargar
		// Recargar tabla si usas DataTables
		$('#cantones').DataTable().ajax.reload(null, false);



    } else {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: data.message || 'Ocurrió un error al guardar el cantón.'
      });
    }
  }, 'json');
}

// Asociar al botón
$(document).ready(function () {
  $('#btnGuardarCanton').on('click', function (e) {
    e.preventDefault();
    actualizarCanton();
  });
});
</script>

<script>
$(document).on('click', '.btn-eliminar', function () {
  const id = $(this).data('id');
	
  Swal.fire({
    title: '¿Estás segura?',
    text: 'Esta acción eliminará la zona permanentemente.',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar'
  }).then((result) => {	  
    if (result.isConfirmed) {
      $.post('eliminar_canton.php', { id }, function (response) {
        if (response.success) {
			
          Swal.fire('Eliminada', 'La zona fue eliminada correctamente.', 'success');

          // Elimina visualmente la fila sin recargar
          $('button.btn-eliminar[data-id="' + id + '"]').closest('tr').remove();
        } else {
          Swal.fire('Error', response.message || 'No se pudo eliminar.', 'error');
        }
      }, 'json');
    }
  });
});

</script>



</body>
</html>
