<?php
if (isset($_GET['Accion'])) {
    $accion = $_GET['Accion'];

    switch ($accion) {
        case "GetZona":
            GetZona();
            break;
        case "GetZona2":
            GetZona2(); // Asegúrate de definir esta función si la usas
            break;
		case "GetTable":
            GetTable(); // Asegúrate de definir esta función si la usas
            break;
		case "GetZonas":
            GetZonas(); // Asegúrate de definir esta función si la usas
            break;
		case "GetCantonesPorZona":
            GetCantonesPorZona(); // Asegúrate de definir esta función si la usas
            break;			
        default:
            echo "Acción no válida.";
            break;
    }
}

/**
 * Obtiene las zonas activas desde la tabla tbr_zona
 * y devuelve una lista de opciones <option>
 */
function GetZona() {
    include("conex.php");

    if (!$conex) {
        die("Error de conexión: " . mysqli_connect_error());
    }

    $sql = "SELECT id, zona FROM tb_zona WHERE condicion = 1 ORDER BY zona ASC";
    $Consulta = mysqli_query($conex, $sql);

    if (!$Consulta) {
        die("Error en la consulta: " . mysqli_error($conex));
    }

    $opciones = "<option value=''>Seleccione la zona</option>"; 

    while ($fila = mysqli_fetch_assoc($Consulta)) {
        $opciones .= "<option value='" . htmlspecialchars($fila["id"], ENT_QUOTES) . "'>" . htmlspecialchars($fila["zona"], ENT_QUOTES) . "</option>";
    }

    mysqli_close($conex);
    echo $opciones;
}

/**
 * Define aquí la función GetZona2 si se usa
 */
function GetZona2() {
    include("conex.php");

    if (!$conex) {
        die("Error de conexión: " . mysqli_connect_error());
    }

    $sql = "SELECT id, zona FROM tb_zona WHERE condicion = 1 ORDER BY zona ASC";
    $Consulta = mysqli_query($conex, $sql);

    if (!$Consulta) {
        die("Error en la consulta: " . mysqli_error($conex));
    }

    $opciones = "<option value=''>Seleccione la zona</option>"; 

    while ($fila = mysqli_fetch_assoc($Consulta)) {
        $opciones .= "<option value='" . htmlspecialchars($fila["id"], ENT_QUOTES) . "'>" . htmlspecialchars($fila["zona"], ENT_QUOTES) . "</option>";
    }

    mysqli_close($conex);
    echo $opciones;
}
//Funcion table
function GetTable() {
    include("conex.php");

    if (!$conex) {
        die("Error de conexión: " . mysqli_connect_error());
    }

    $sql = "SELECT t.id, t.marca, t.modelo, t.serie
			FROM tb_table AS t
			LEFT JOIN tb_vehiculo AS v ON v.id_table = t.id AND v.condicion = 1
			WHERE t.condicion = 1 AND v.id_table IS NULL
			ORDER BY t.id DESC;";
    $Consulta = mysqli_query($conex, $sql);

    if (!$Consulta) {
        die("Error en la consulta: " . mysqli_error($conex));
    }

    $opciones = "<option value=''>Seleccione la table</option>"; 

    while ($fila = mysqli_fetch_assoc($Consulta)) {
        $opciones .= "<option value='" . htmlspecialchars($fila["id"], ENT_QUOTES) . "'>" . htmlspecialchars($fila["marca"].' '.$fila["modelo"].' '.$fila["serie"], ENT_QUOTES) . "</option>";
    }

    mysqli_close($conex);
    echo $opciones;
}

function GetZonas() {
  include "conex.php";
  $query = mysqli_query($conex, "SELECT id, zona FROM tb_zona WHERE condicion = 1");

  while ($row = mysqli_fetch_assoc($query)) {
    echo '<option value="' . $row['id'] . '">' . htmlspecialchars($row['zona']) . '</option>';
  }
  exit;
}

function GetCantonesPorZona() {
  include "conex.php";
  $idZona = intval($_POST['id_zona']);
  $query = mysqli_query($conex, "SELECT id, canton FROM tb_canton WHERE id_zona = $idZona AND condicion = 1");

  while ($row = mysqli_fetch_assoc($query)) {
    echo '<option value="' . $row['id'] . '">' . htmlspecialchars($row['canton']) . '</option>';
  }
  exit;
}

?>
