<?php
include "conex.php";
header('Content-Type: application/json');

// Recibir y limpiar datos
$id = intval($_POST['id'] ?? 0);
$id_zona = intval($_POST['id_zona'] ?? 0);
$canton = trim($_POST['canton'] ?? '');

if ($id <= 0 || $id_zona <= 0 || $canton === '') {
    echo json_encode(['success' => false, 'message' => 'Datos inválidos o incompletos.']);
    exit;
}

// Preparar y ejecutar la consulta
$stmt = $conex->prepare("UPDATE tb_canton SET id_zona = ?, canton = ? WHERE id = ?");
$stmt->bind_param("isi", $id_zona, $canton, $id);
$ok = $stmt->execute();

if ($ok) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al actualizar.']);
}

$stmt->close();
$conex->close();
exit;
