<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/conex.php';

/* === Resolver conexión === */
$db = null;
if (isset($conex) && $conex instanceof mysqli) { $db = $conex; }
elseif (isset($conn) && $conn instanceof mysqli) { $db = $conn; }
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos']); exit; }

mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/* === (Opcional) Verificar sesión === */
if (!isset($_SESSION['idusuario'])) {
  echo json_encode(['success'=>false,'message'=>'Sesión expirada']); exit;
}

/* === Entrada === */
$id        = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$marca     = trim($_POST['marca']     ?? '');
$direccion = trim($_POST['direccion'] ?? '');
$telefono  = trim($_POST['telefono']  ?? '');
$email     = trim($_POST['email']     ?? '');
$contacto  = trim($_POST['contacto']  ?? '');
$telefonoc = trim($_POST['telefonoc'] ?? '');
$plan      = trim($_POST['plan']      ?? '');
$tiempo    = trim($_POST['tiempo']    ?? '');
$valorRaw  = (string)($_POST['valor'] ?? '');

/* Permitir coma decimal */
$valorRaw = str_replace(',', '.', $valorRaw);

/* === Validaciones === */
if ($id<=0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }
if ($marca==='' || $direccion==='' || $telefono==='' || $email==='' || $contacto==='' || $telefonoc==='' || $plan==='' || $tiempo==='' || $valorRaw==='') {
  echo json_encode(['success'=>false,'message'=>'Todos los campos son obligatorios']); exit;
}
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  echo json_encode(['success'=>false,'message'=>'Email no válido']); exit;
}
if (!is_numeric($valorRaw)) {
  echo json_encode(['success'=>false,'message'=>'Valor debe ser numérico']); exit;
}
$valor = (float)$valorRaw;
if ($valor < 0) {
  echo json_encode(['success'=>false,'message'=>'Valor no puede ser negativo']); exit;
}

/* === Update === */
$sql = "UPDATE tb_marca SET
          nombre_marca=?, direccion=?, telefono=?, email=?,
          contacto=?, telefono_contacto=?, plan=?, tiempo=?, valor=?
        WHERE id=? AND condicion=1";

$stmt = $db->prepare($sql);
if (!$stmt) {
  echo json_encode(['success'=>false,'message'=>'SQL prep: '.$db->error]); exit;
}

/* 7 strings + 1 double + 1 int */
if (!$stmt->bind_param('sssssssdii',
    $marca, $direccion, $telefono, $email, $contacto, $telefonoc, $plan, $tiempo, $valor, $id
)) {
  echo json_encode(['success'=>false,'message'=>'bind_param: '.$stmt->error]); exit;
}

if (!$stmt->execute()) {
  echo json_encode(['success'=>false,'message'=>'execute: '.$stmt->error]); exit;
}

/* Affected rows: 0 => sin cambios */
echo json_encode([
  'success' => true,
  'message' => ($stmt->affected_rows === 0 ? 'Sin cambios' : 'Actualizado correctamente')
]);
