<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
require_once __DIR__ . '/conex.php';

if (!isset($_SESSION['idusuario'])) {
  echo json_encode(['success'=>false,'message'=>'Sesin expirada.'], JSON_UNESCAPED_UNICODE); exit;
}
if (!isset($conex) || !$conex instanceof mysqli) {
  echo json_encode(['success'=>false,'message'=>'Sin conexin a BD.'], JSON_UNESCAPED_UNICODE); exit;
}
mysqli_set_charset($conex, 'utf8mb4');

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) {
  echo json_encode(['success'=>false,'message'=>'ID invlido.'], JSON_UNESCAPED_UNICODE); exit;
}

// Obtener ruta
$stmt = mysqli_prepare($conex, "SELECT ruta FROM tb_video WHERE id = ? AND condicion = 1 LIMIT 1");
if (!$stmt) {
  echo json_encode(['success'=>false,'message'=>'Error al preparar la consulta.'], JSON_UNESCAPED_UNICODE); exit;
}
mysqli_stmt_bind_param($stmt, 'i', $id);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $ruta);
$found = mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

if (!$found) {
  echo json_encode(['success'=>false,'message'=>'Registro no encontrado.'], JSON_UNESCAPED_UNICODE); exit;
}

// Baja lgica
$stmt2 = mysqli_prepare($conex, "UPDATE tb_video SET condicion = 0 WHERE id = ?");
if (!$stmt2) {
  echo json_encode(['success'=>false,'message'=>'Error al preparar la actualizacin.'], JSON_UNESCAPED_UNICODE); exit;
}
mysqli_stmt_bind_param($stmt2, 'i', $id);
$ok = mysqli_stmt_execute($stmt2);
mysqli_stmt_close($stmt2);

// Borrar archivo fsico (opcional)
if ($ok && $ruta) {
  $full = __DIR__ . '/' . ltrim($ruta, '/');
  if (is_file($full)) { @unlink($full); }
}

echo json_encode(['success'=>$ok ? true : false, 'message'=>$ok ? 'El video fue eliminado.' : 'No se pudo eliminar.'], JSON_UNESCAPED_UNICODE);
