<?php
session_start();
include("conex.php");

// Verificar sesin
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesin expirada."]));
}

$sql = "SELECT id, nombre_marca, direccion, telefono, email, contacto,
               telefono_contacto, plan, tiempo, valor, activo, condicion
		FROM tb_marca WHERE condicion = 1";
$consulta = mysqli_query($conex, $sql);

if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conex)]));
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    $activo_texto = $row['activo'] == 1 ? "SI" : "NO";

$boton_estado = '<div class="switch-wrapper text-center">
    <label class="switch-custom">
        <input type="checkbox" class="toggle-switch" 
            data-id="' . $row['id'] . '" 
            ' . ($row['activo'] ? 'checked' : '') . ' 
            data-estado="' . ($row['activo'] ? 1 : 0) . '">
        <span class="slider-custom">
            <i class="fas fa-power-off icon-off"></i>
            <i class="fas fa-check icon-on"></i>
        </span>
    </label>
</div>';






    $eliminar = '<button class="btn btn-danger btn-eliminar" data-id="' . $row['id'] . '">
               <i class="fa fa-trash"></i>
             </button>';


    $editar = '
        <button class="btn btn-warning btn-sm toggle-editar" 
                data-id="' . $row['id'] . '" 
                data-marca="' . htmlspecialchars($row['nombre_marca'], ENT_QUOTES) . '"
                data-direccion="' . htmlspecialchars($row['direccion'], ENT_QUOTES) . '"
                data-telefono="' . htmlspecialchars($row['telefono'], ENT_QUOTES) . '"
                data-email="' . htmlspecialchars($row['email'], ENT_QUOTES) . '"
                data-contacto="' . htmlspecialchars($row['contacto'], ENT_QUOTES) . '"
                data-telefonoc="' . htmlspecialchars($row['telefono_contacto'], ENT_QUOTES) . '"
                data-plan="' . htmlspecialchars($row['plan'], ENT_QUOTES) . '"
                data-tiempo="' . htmlspecialchars($row['tiempo'], ENT_QUOTES) . '"
                data-valor="' . htmlspecialchars($row['valor'], ENT_QUOTES) . '"
				>
            <i class="fa fa-pencil"></i>
        </button>';

    $usuarios_data[] = [
        "marca"   => $row['nombre_marca'],
        "direccion"   => $row['direccion'],
        "telefono"   => $row['telefono'],
        "email"   => $row['email'],
        "contacto"   => $row['contacto'],
        "telefonoc"   => $row['telefono_contacto'],
        "plan"   => $row['plan'],
        "tiempo"   => $row['tiempo'],		
        "valor"   => $row['valor'],		
        "activo" => $boton_estado,
        "accion" => $editar . ' ' . $eliminar
    ];
}

echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
