<?php
session_start();
include("conex.php");

if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["data" => [], "error" => "Sesin expirada."]);
    exit;
}

$sql = "SELECT 
            p.id, 
            p.fecha_inicio, 
            p.fecha_fin, 
            p.activo, 
            m.nombre_marca,
			m.valor,
            z.zona, 
            c.canton, 
            v.video,
			v.ruta
        FROM tb_publicidad AS p 
        INNER JOIN tb_marca AS m ON m.id = p.id_marca
        INNER JOIN tb_zona AS z ON z.id = p.id_zona
        INNER JOIN tb_canton AS c ON c.id = p.id_canton
        INNER JOIN tb_video AS v ON v.id = p.id_video
        WHERE p.condicion = 1";

$result = mysqli_query($conex, $sql);

if (!$result) {
    echo json_encode(["data" => [], "error" => "Error en la consulta: " . mysqli_error($conex)]);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $data[] = [
        "id"      => $row['id'],
        "marca"   => $row['nombre_marca'],
        "zona"    => $row['zona'],
        "canton"  => $row['canton'],
        "video"   => $row['video'],
        "fechai"  => $row['fecha_inicio'],
        "fechaf"  => $row['fecha_fin'],
        "activo"  => (int)$row['activo']
    ];
}

echo json_encode(["data" => $data], JSON_UNESCAPED_UNICODE);
