<?php
session_start();
include("conex.php");

// Verificar sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

// Consulta que une canton con su zona
$sql = "SELECT t.id, t.marca, t.modelo, t.serie, t.estado, t.activa, t.condicion        
		FROM tb_table AS t        
        WHERE t.condicion = 1";

$consulta = mysqli_query($conex, $sql);

if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conex)]));
}

$usuarios_data = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    $boton_estado = '
        <div class="switch-wrapper text-center">
            <label class="switch-custom">
                <input type="checkbox" class="toggle-switch" 
                    data-id="' . $row['id'] . '" 
                    ' . ($row['activa'] ? 'checked' : '') . ' 
                    data-activa="' . ($row['activa'] ? 1 : 0) . '">
                <span class="slider-custom">
                    <i class="fas fa-power-off icon-off"></i>
                    <i class="fas fa-check icon-on"></i>
                </span>
            </label>
        </div>';

    $editar = '
        <button class="btn btn-warning btn-sm toggle-editar" 
                data-id="' . $row['id'] . '" 
                data-marca="' . htmlspecialchars($row['marca'], ENT_QUOTES) . '"
                data-modelo="' . htmlspecialchars($row['modelo'], ENT_QUOTES) . '"
                data-serie="' . htmlspecialchars($row['serie'], ENT_QUOTES) . '"
                data-estado="' . htmlspecialchars($row['estado'], ENT_QUOTES) . '"
				>
            <i class="fa fa-pencil"></i>
        </button>';

    $eliminar = '
        <button class="btn btn-danger btn-sm btn-eliminar" 
                data-id="' . $row['id'] . '">
            <i class="fa fa-trash"></i>
        </button>';

    $usuarios_data[] = [
        "marca"   => $row['marca'],
        "modelo" => $row['modelo'],
        "serie" => $row['serie'],
        "estado" => $row['estado'],
        "activo" => $boton_estado,
        "accion" => $editar . ' ' . $eliminar
    ];
}

echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
