<?php
session_start();
include("conex.php");

// Verificar sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

// Consulta que une tb_vehiculo con tb_table (modelo, serie, estado)
$sql = "SELECT v.id, v.placa, v.nombre, v.telefono, v.cooperativa, v.activo, v.id_table, 
              v.id_zona, z.zona, v.id_canton, c.canton, t.modelo, t.serie, t.estado, v.condicion      
        FROM tb_vehiculo AS v
        LEFT JOIN tb_table AS t ON t.id = v.id_table
		INNER JOIN tb_zona AS z ON z.id = v.id_zona
		INNER JOIN tb_canton AS c ON c.id = v.id_canton
        WHERE v.condicion = 1";

$consulta = mysqli_query($conex, $sql);

if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conex)]));
}

$usuarios_data = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    $boton_estado = '
        <div class="switch-wrapper text-center">
            <label class="switch-custom">
                <input type="checkbox" class="toggle-switch" 
                    data-id="' . $row['id'] . '" 
                    ' . ($row['activo'] ? 'checked' : '') . ' 
                    data-activa="' . ($row['activo'] ? 1 : 0) . '">
                <span class="slider-custom">
                    <i class="fas fa-power-off icon-off"></i>
                    <i class="fas fa-check icon-on"></i>
                </span>
            </label>
        </div>';

    $editar = '
        <button class="btn btn-warning btn-sm toggle-editar" 
                data-id="' . $row['id'] . '" 
                data-placa="' . htmlspecialchars($row['placa'], ENT_QUOTES) . '"
                data-nombre="' . htmlspecialchars($row['nombre'], ENT_QUOTES) . '"
                data-telefono="' . htmlspecialchars($row['telefono'], ENT_QUOTES) . '"
                data-cooperativa="' . htmlspecialchars($row['cooperativa'], ENT_QUOTES) . '"                
                data-id_zona="' . htmlspecialchars($row['id_zona'], ENT_QUOTES) . '"                
                data-id_canton="' . htmlspecialchars($row['id_canton'], ENT_QUOTES) . '"                
                data-id_table="' . htmlspecialchars($row['id_table'], ENT_QUOTES) . '"                
                >
            <i class="fa fa-pencil"></i>
        </button>';

    $eliminar = '
        <button class="btn btn-danger btn-sm btn-eliminar" 
                data-id="' . $row['id'] . '">
            <i class="fa fa-trash"></i>
        </button>';

    $usuarios_data[] = [
        "placa"        => $row['placa'],
        "nombre"       => $row['nombre'],
        "telefono"     => $row['telefono'],
        "cooperativa"  => $row['cooperativa'], 
		"zona"         => $row['zona'],
        "canton"       => $row['canton'], 
		"activo"       => $boton_estado,
        "serie"        => $row['modelo'].' '.$row['serie'],        
        "accion"       => $editar . ' ' . $eliminar
    ];
}

echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
