<?php
declare(strict_types=1);

// Respuesta JSON siempre en UTF-8
header('Content-Type: application/json; charset=utf-8');

session_start();
require_once __DIR__ . '/conex.php';

// ===== Validacin de sesin (ajusta a tu llave real) =====
if (
  !isset($_SESSION['idusuario']) &&
  !isset($_SESSION['usuario'])
) {
  echo json_encode(['data' => [], 'error' => 'Sesin expirada.'], JSON_UNESCAPED_UNICODE);
  exit;
}

// ===== Conexin BD =====
if (!isset($conex) || !$conex instanceof mysqli) {
  echo json_encode(['data' => [], 'error' => 'Sin conexin a la base de datos.'], JSON_UNESCAPED_UNICODE);
  exit;
}
mysqli_set_charset($conex, 'utf8mb4');

// ===== Consulta =====
// Ajusta nombres de columnas si difieren en tu esquema
$sql = "SELECT id, video, ruta, activo
        FROM tb_video
        WHERE condicion = 1
        ORDER BY id DESC";

$res = mysqli_query($conex, $sql);
if (!$res) {
  echo json_encode([
    'data'  => [],
    'error' => 'Error en la consulta: ' . mysqli_error($conex)
  ], JSON_UNESCAPED_UNICODE);
  exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
  $id     = (int)$row['id'];
  $video  = (string)$row['video'];
  $ruta   = (string)$row['ruta'];
  $activo = (int)$row['activo'];

  // ===== Switch Activo (HTML) =====
  $boton_estado = '
    <div class="switch-wrapper text-center">
      <label class="switch-custom m-0">
        <input type="checkbox" class="toggle-switch"
               data-id="' . $id . '" ' . ($activo ? 'checked' : '') . '>
        <span class="slider-custom">
          <span class="icon-off"><i class="fas fa-times"></i></span>
          <span class="icon-on"><i class="fas fa-check"></i></span>
        </span>
      </label>
    </div>';

  // ===== Botn Eliminar (HTML) =====
  $btn_eliminar = '
    <div class="text-center">
      <button class="btn btn-danger btn-sm btn-eliminar" data-id="' . $id . '">
        <i class="fa fa-trash"></i>
      </button>
    </div>';

  // ===== Columna de video (HTML) =====
  // Opcin 1: autoplay loop (muted)
  $html_video = '
    <video width="160" height="90" muted autoplay loop preload="metadata" playsinline>
      <source src="' . htmlspecialchars($ruta, ENT_QUOTES, 'UTF-8') . '" type="video/mp4">
      Tu navegador no soporta la reproduccin de video.
    </video>';

  // Opcin 2 (si prefieres controles):
  // $html_video = '
  //   <video width="180" height="100" controls muted preload="metadata" playsinline>
  //     <source src="' . htmlspecialchars($ruta, ENT_QUOTES, 'UTF-8') . '" type="video/mp4">
  //     Tu navegador no soporta la reproduccin de video.
  //   </video>';

  $data[] = [
    'video'  => htmlspecialchars($video, ENT_QUOTES, 'UTF-8'), // descripcin
    'ruta'   => $html_video,                                   // reproductor embebido
    'activo' => $boton_estado,                                 // switch
    'accion' => $btn_eliminar                                   // acciones
  ];
}

// Entrega para DataTables
echo json_encode(['data' => $data], JSON_UNESCAPED_UNICODE);
