<?php
session_start();
include("conex.php");

// Verificar sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$sql = "SELECT id, zona, activa, condicion FROM tb_zona WHERE condicion = 1";
$consulta = mysqli_query($conex, $sql);

if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conex)]));
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    $activo_texto = $row['activa'] == 1 ? "SI" : "NO";

$boton_estado = '<div class="switch-wrapper text-center">
    <label class="switch-custom">
        <input type="checkbox" class="toggle-switch" 
            data-id="' . $row['id'] . '" 
            ' . ($row['activa'] ? 'checked' : '') . ' 
            data-estado="' . ($row['activa'] ? 1 : 0) . '">
        <span class="slider-custom">
            <i class="fas fa-power-off icon-off"></i>
            <i class="fas fa-check icon-on"></i>
        </span>
    </label>
</div>';






    $eliminar = '<button class="btn btn-danger btn-eliminar" data-id="' . $row['id'] . '">
               <i class="fa fa-trash"></i>
             </button>';


    $editar = '<button class="btn btn-warning toggle-editar" data-id="' . $row['id'] . '" data-zona="' . $row['zona'] . '">
                <i class="fa fa-pencil"></i>
              </button>';

    $usuarios_data[] = [
        "zona"   => $row['zona'],
        "activo" => $boton_estado,
        "accion" => $editar . ' ' . $eliminar
    ];
}

echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
